//
//  VankeNoticeListAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeNoticeListAPI.h"
#import "VankeConfig.h"
#import "VankeUtil.h"

@implementation VankeNoticeListAPI

@synthesize publishTimeBegin;

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        [self http_get:@"/project/queryprojectsby"].PARAM(@"publishTimeBegin", self.publishTimeBegin).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
//        self.serverResp = [NoticeListResponse objectFromDictionary: self.responseJSONDictionary];
        NoticeListResponse *resp = [[NoticeListResponse alloc] init];
        NSMutableArray *ary = [[NSMutableArray alloc] initWithCapacity:10];
        for (int i = 0; i < 10; ++i) {
            Notice *obj = [[Notice alloc]init];
            obj.noticeId = [NSString stringWithFormat:@"%d", i];
            obj.title = [NSString stringWithFormat:@"重要通知%d", i];
            obj.publishTime = @"2015-11-15";
            obj.publisher = @"张三";
            
            if (i % 3 == 0) {
                 obj.priority  = @"低";
                
            } else if (i % 3 == 1) {
                 obj.priority  = @"中";
                
            } else if (i % 3 == 2) {
                obj.priority  = @"高";
            }
            
            
            obj.content = @"销售录入对账单...";
            obj.attachment = @"a.png";
            [ary addObject:obj];
        }
        resp.data = ary;
        self.serverResp = resp;
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    } else if (self.failed) {
        NSLog(@"response: %@", self.responseString);
        self.serverResp = [NoticeListResponse objectFromDictionary: self.responseJSONDictionary];
    }
}

-(BOOL) checkToQuery {
//    if ([VankeUtil isBlankString:self.publishTimeBegin]) {
//        [self setClientError: @"发布日期不能为空"];
//        return NO;
//    }
    
    return YES;
}

@end

#pragma Notice

@implementation Notice

@synthesize noticeId;
@synthesize title;
@synthesize publisher;
@synthesize publishTime;
@synthesize priority;
@synthesize content;
@synthesize attachment;

-(NSString*) getAttachmentUrl {
    if ([VankeUtil isBlankString:self.attachment]) {
        return nil;
    } else {
        return [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_MEDIA_BASE_URL, self.attachment];
    }
}

@end

#pragma NoticeListResponse

@implementation NoticeListResponse

@synthesize data;

CONVERT_PROPERTY_CLASS(data, Notice)

-(int) total {
    return nil == data ? 0 :[data count];
}

@end
