//
//  VankeSettlementListAPI.h
//  vanke
//  查询对账单列表
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeBaseAPI.h"
#import "VankeResponse.h"

@class Paging;
@class SubjectItem;
@class StatementShop;
@class StatementListResponse;


/*
 * 查询对账单列表
 * http://.../wanke-server/rest/statement/query?settleEquals={settleEquals}&confirmed={confirmed}&authorizedOrgIn={authorizedOrgIn}&shopLike={shopLike}&pageNumber={pageNumber}&pageSize={pageSize}
 */
@interface VankeSettlementListAPI : VankeBaseAPI

// 账期等于
@property (nonatomic, strong) NSDate *settleEquals;

// 状态: unconfirmed, confirmed, rejected
@property (nonatomic, strong) NSString *billState;

// 项目列表
@property (nonatomic, strong) NSArray *projectsIn;

// 商铺名称或代码类似于
@property (nonatomic, strong) NSString *shopLike;

@property (nonatomic, assign) NSInteger pageNumber;
@property (nonatomic, assign) NSInteger pageSize;

@end

// 分页信息
@interface Paging : BeeActiveObject

@property (nonatomic, strong) NSNumber *page;
@property (nonatomic, strong) NSNumber *pageSize;
@property (nonatomic, strong) NSNumber *pageCount;
@property (nonatomic, strong) NSNumber *recordCount;

@end

// 对账单科目
@interface SubjectItem : BeeActiveObject

@property (nonatomic, strong) NSString *subject;
@property (nonatomic, strong) NSString *beginDate;
@property (nonatomic, strong) NSString *endDate;
@property (nonatomic, strong) NSNumber *direction;
@property (nonatomic, strong) NSNumber *amount;
@property (nonatomic, strong) NSString *remark;

@end

// 对账单合计
@interface StatementShop : BeeActiveObject

@property (nonatomic, strong) NSString *contract;
@property (nonatomic, strong) NSString *shopCode;
@property (nonatomic, strong) NSString *shopName;
@property (nonatomic, strong) NSString *picture;
@property (nonatomic, strong) NSString *settle;
@property (nonatomic, strong) NSNumber *amount;
@property (nonatomic, strong) NSString *state;
@property (nonatomic, strong) NSArray *items; // SubjectItem

-(NSString*) getPictureUrlOrDefault;
-(NSString*) codeName;
-(BOOL) unconfirmed;

@end

@interface StatementListResponseData : BeeActiveObject

@property (nonatomic, strong) NSNumber *amount;
@property (nonatomic, strong) Paging *paging;
@property (nonatomic, strong) NSArray *records; // StatementShop

@end

// 对账单返回
@interface StatementListResponse : VankeResponse

@property (nonatomic, strong) NSDate *settle;
@property (nonatomic, strong) StatementListResponseData *data;

-(BOOL) hasMore;

@end