//
//  VankeSettlementListAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeSettlementListAPI.h"
#import "VankeConfig.h"
#import "VankeUtil.h"

@implementation VankeSettlementListAPI

@synthesize settleEquals = _settleEquals;
@synthesize billState = _billState;
@synthesize projectsIn = _projectsIn;
@synthesize shopLike = _shopLike;
@synthesize pageNumber = _pageNumber;
@synthesize pageSize = _pageSize;

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        BeeHTTPRequest *request = [self http_get:@"/statement/query"].PARAM(@"settleEquals", [self getSettleStr]).PARAM(@"authorizedOrgIn", [self.projectsIn componentsJoinedByString:@";"])
        .PARAM(@"pageNumber", [NSString stringWithFormat:@"%lu", _pageNumber - 1]).PARAM(@"pageSize", [NSString stringWithFormat:@"%lu", _pageSize]);
        if (![VankeUtil isBlankString:_billState]) {
            request.PARAMS(@"state", _billState);
        }
        if (![VankeUtil isBlankString:_shopLike]) {
            request.PARAM(@"shopLike", _shopLike);
        }
        request.TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        StatementListResponse *resp = [StatementListResponse objectFromDictionary: self.responseJSONDictionary];
        resp.settle = self.settleEquals;
        
        self.serverResp = resp;
        if (nil == self.serverResp)
        {
            self.failed = YES;
            return;
        }
    } else if (self.failed) {
        NSLog(@"response: %@", self.responseString);
        self.serverResp = [StatementListResponse objectFromDictionary: self.responseJSONDictionary];
    }
}

-(BOOL) checkToQuery {
    if (nil == _settleEquals) {
        [self setClientError: @"账期不能为空"];
        return NO;
    }
    
    if (nil == self.projectsIn || [self.projectsIn count] <= 0) {
        [self setClientError: @"项目列表不能为空"];
        return NO;
    }
    
    return YES;
}

-(NSString*) getSettleStr {
    if (nil == _settleEquals) {
        return @"";
    }
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyyMM"];
    return [dateFormatter stringFromDate:_settleEquals];
}

@end

#pragma Paging

@implementation Paging

@synthesize page = _page;
@synthesize pageSize = _pageSize;
@synthesize pageCount = _pageCount;
@synthesize recordCount = _recordCount;

@end


#pragma SubjectItem

@implementation SubjectItem

@synthesize subject = _subject;
@synthesize beginDate = _beginDate;
@synthesize endDate = _endDate;
@synthesize direction = _direction;
@synthesize amount = _amount;
@synthesize remark = _remark;

@end

#pragma  StatementShop

@implementation StatementShop

@synthesize contract = _contract;
@synthesize shopCode = _shopCode;
@synthesize shopName = _shopName;
@synthesize picture = _picture;
@synthesize settle = _settle;
@synthesize amount = _amount;
@synthesize state = _state;
@synthesize items = _items;

CONVERT_PROPERTY_CLASS(items, SubjectItem)

-(NSString*) getPictureUrlOrDefault {
    if ([VankeUtil isBlankString:self.picture]) {
        return @"bill_icon.png";
    } else {
        return [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_MEDIA_BASE_URL, self.picture];
    }
}

-(NSString*) codeName {
    return [NSString stringWithFormat:@"%@ %@", _shopCode, _shopName];
}

-(BOOL) unconfirmed {
    return [_state eq: @"unconfirmed"];
}

@end

#pragma StatementListResponseData

@implementation StatementListResponseData

@synthesize amount = _amount;
@synthesize paging = _paging;
@synthesize records = _records;

CONVERT_PROPERTY_CLASS(records, StatementShop)

@end

#pragma StatementListResponse

@implementation StatementListResponse

@synthesize settle =  _settle;
@synthesize data = _data;

-(BOOL) hasMore {
    return _data && _data.paging && (_data.paging.pageSize <= _data.paging.recordCount);
}

@end



