//
//  VankeSettlementRejectAPI.m
//  vanke
//
//  Created by xiaomi on 15/11/26.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeSettlementRejectAPI.h"
#import "VankeUtil.h"
#import "VankeCommonModel.h"

@implementation VankeSettlementRejectAPI

@synthesize contract = _contract;
@synthesize settle = _settle;
@synthesize message = _message;

-(void) route:(BeeMessage *)msg {
    if (self.sending) {
        if (![self checkToQuery]) {
            return;
        }

        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
        NSString *operTime = [dateFormatter stringFromDate:[NSDate date]];
        User *curUser = [[VankeCommonModel sharedInstance] currentUser];
        
        NSString *url = [NSString stringWithFormat:@"/statement/confirm"];
        NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:
                              self.contract, @"contract",
                              self.settle, @"settle",
                              @"rejected", @"state",
                              _message, @"message",
                              operTime, @"time",
                              curUser.uuid, @"operId",
                              curUser.name, @"operName",
                              nil];
        NSString *postData = [VankeUtil dictToJsonString: dict];
        
        [self http_post: url].BODY(postData).TIMEOUT(10);
    }
    else if (self.succeed) {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [VankeResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.contract]) {
        [self setClientError: @"合同编号不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.settle]) {
        [self setClientError: @"账单日期不能为空"];
        return NO;
    }
    
    return YES;
}

@end
