
//
//  VankeCommonModel.m
//  vanke
//
//  Created by xiaomi on 15/10/7.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeCommonModel.h"
#import "VankeConfig.h"

#pragma mark -

@implementation VankeCommonModel

DEF_SINGLETON(VankeCommonModel)

- (void) saveLoginInfo: (LoginResponseData*) info password: (NSString*) password {
    if (nil == info) {
        [self removeLoginInfo];
        return;
    }
    
    [self userDefaultsWrite:[info objectToDictionary] forKey:KEY_CURRENT_USER_INFO];
    [self keychainWrite:password forKey:KEY_CURRENT_USER_PWD];
}


- (LoginResponseData*) getLoginInfo {
    NSDictionary *dict = [self userDefaultsRead:KEY_CURRENT_USER_INFO];
    if (nil == dict) {
        return nil;
    }
    
    return [LoginResponseData objectFromDictionary: dict];
}

- (void) removeLoginInfo {
    [self userDefaultsRemove:KEY_CURRENT_USER_INFO];
    [self keychainDelete:KEY_CURRENT_USER_PWD];
}

- (User*) currentUser {
    LoginResponseData *data = [self getLoginInfo];
    if (nil != data) {
        return [data getUser];
    } else {
        return nil;
    }
}

- (Enterpirse*) currentEnt {
    LoginResponseData *data = [self getLoginInfo];
    if (nil != data) {
        return [data getEnterprise];
    } else {
        return nil;
    }
}

-(NSArray*) getAuthOrgs {
    LoginResponseData *data = [self getLoginInfo];
    if (nil != data) {
        return data.authorizedOrgs;
    } else {
        return nil;
    }
    // TODO FOR TEST
//    NSMutableArray *ary = [[NSMutableArray alloc] initWithCapacity:20];
//    for( int i = 0; i < 20; ++i) {
//        AuthorizedOrg *org = [[AuthorizedOrg alloc] init];
//        org.uuid = [NSString stringWithFormat:@"%d", i];
//        org.code = [NSString stringWithFormat:@"CODE%d", i];
//        org.name = [NSString stringWithFormat:@"项目%d", i];
//        org.picture = [NSString stringWithFormat:@"PICTURE%d", i];
//        [ary addObject:org];
//    }
//    return ary;
}

- (NSString*) currentUserPwd {
    return [self keychainRead:KEY_CURRENT_USER_PWD];
}

@end
