//
//  VankeNoticeListModel.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeNoticeListModel.h"
#import "VankeNoticeListAPI.h"

#undef	PER_PAGE
#define PER_PAGE	(30)

@implementation VankeNoticeListModel

@synthesize publishTimeBegin = _publishTimeBegin;
@synthesize notices = _notices;
@synthesize readed = _readed;

- (void)load
{
    self.autoSave = YES;
    self.autoLoad = YES;
    self.notices = [NSMutableArray array];
}

- (void)unload
{
    self.publishTimeBegin = nil;
    self.notices = nil;
}

#pragma mark - cache

- (void)loadCache
{
    [self.notices removeAllObjects];
    [self.notices addUniqueObjectsFromArray:[Notice readObjectForKey:self.publishTimeBegin]
                                  compare:^NSComparisonResult(id left, id right) {
                                      return [((Notice*)left).noticeId compare:((Notice*)right).noticeId];
                                  }];
}

- (void)saveCache
{
    [Notice saveObject:self.notices forKey:self.publishTimeBegin];
}

- (void)clearCache
{
    [self.notices removeAllObjects];
    [Notice removeObjectForKey:self.publishTimeBegin];
}

#pragma mark - paging query

- (void)firstPage
{
    [self gotoPage:1];
}

- (void)nextPage
{
    if ( self.notices.count )
    {
        [self gotoPage:(self.notices.count / PER_PAGE + 1)];
    }
}

-(void) loadFromServer {
    
}

- (void)gotoPage:(NSUInteger)page {
    [VankeNoticeListAPI cancel];
    
    VankeNoticeListAPI *api = [VankeNoticeListAPI api];
    
    @weakify(api);
    @weakify(self);
    
    api.publishTimeBegin = self.publishTimeBegin;
    
    api.whenUpdate = ^
    {
        @normalize(api);
        @normalize(self);
        
        if ( api.sending )
        {
            [self sendUISignal:self.RELOADING];
        }
        else
        {
            if ( api.succeed )
            {
                NoticeListResponse *resp = (NoticeListResponse*) api.serverResp;
                
                if ( nil == resp || nil == resp.data )
                {
                    api.failed = YES;
                }
                else
                {
                    if ( page <= 1 )
                    {
                        [self.notices removeAllObjects];
                        [self.notices addObjectsFromArray:resp.data];
                    }
                    else
                    {
                        [self.notices addObjectsFromArray:resp.data];
                        [self.notices unique:^NSComparisonResult(id left, id right) {
                            return [((Notice *)left).noticeId compare:((Notice *)right).noticeId];
                        }];
                    }
                    
                    self.more = (self.notices.count >= [resp total]) ? NO : YES;
                    self.loaded = YES;
                    
                    [self saveCache];
                }
            }
                        
            [self sendUISignal:self.RELOADED];
        }
    };
    
    [api send];
}

@end
