

#import "VankeServiceDashBoard_iPhone.h"

#pragma mark -

@interface VankeServiceDashBoard_iPhone ()
{
}
@end

@implementation VankeServiceDashBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( VankeServiceSaleCell_iPhone, salesInfo );
DEF_OUTLET( VankeServiceBoardCell_iPhone, passenger );
DEF_OUTLET( VankeServiceBoardCell_iPhone, traffic );
DEF_OUTLET( VankeServiceBoardCell_iPhone, energy );
DEF_OUTLET( VankeServiceBoardCell_iPhone, complaint );

@synthesize name = _name;
@synthesize theme = _theme;

+ (id) communityDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"社区2049";
    board.theme = @"red";
    return board;
}

+ (id) centerDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"万科中心";
    board.theme = @"purple";
    return board;
}

+ (id) squreDashBarod {
    VankeServiceDashBoard_iPhone *board = [super cell];
    board.name = @"万科广场";
    board.theme = @"orange";
    return board;
}

- (void)load
{
    self.salesInfo.imgRightBg.backgroundColor = [UIColor colorWithRed:237/255.0 green:27/255.0 blue:35/255.0 alpha:1];
    [self.passenger loadDefaults:@"people.png" title:@"当前客流" bgColor:[UIColor colorWithRed:0 green:195/255.0 blue:230/255.0 alpha:1] unit:@"人" defValue:[NSNumber numberWithInt:0]];
    [self.traffic loadDefaults:@"car.png" title:@"车流" bgColor:[UIColor colorWithRed:79/255.0 green:143/255.0 blue:248/255.0 alpha:1] unit:@"人" defValue:[NSNumber numberWithInt:0]];
    [self.energy loadDefaults:@"energy.png" title:@"坪效" bgColor:[UIColor colorWithRed:149/255.0 green:200/255.0 blue:8/255.0 alpha:1] unit:@"元" defValue:[NSNumber numberWithInt:0]];
    [self.complaint loadDefaults:@"complaint.png" title:@"WIFI登录数" bgColor:[UIColor colorWithRed:252/255.0 green:67/255.0 blue:62/255.0 alpha:1] unit:@"次" defValue:[NSNumber numberWithInt:0]];
}

- (void)unload
{
}

- (BOOL)dataWillChange:(id)newData {
    return self.data != newData;
}

- (void) dataDidChanged {
    ProjectSummary *summary = self.data;
    if (nil != summary) {
        [self.salesInfo setData:summary.salesAmount];
        [self.passenger setData:summary.passengerFlowVolume];
        [self.traffic setData:[NSNumber numberWithFloat:122]];
        [self.energy setData:[NSNumber numberWithInt:789]];
        [self.complaint setData:summary.wifiLoginTimes];
    }
}

-(void) setTheme:(NSString *)theme {
    _theme = theme;
    [self.salesInfo setTheme: theme];
}

@end
