

#import "VankeNoticeListBoardCell_iPhone.h"
#import "VankeUtil.h"

#pragma mark -

@implementation VankeNoticeListBoardCell_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIImageView,      imgPriority )
DEF_OUTLET( BeeUILabel,          lblPriority )
DEF_OUTLET( BeeUILabel,          lblTitle )
DEF_OUTLET( BeeUILabel,          lblPublisher )
DEF_OUTLET( BeeUILabel,          lblPublishTime )

- (BOOL)dataWillChange:(id)newData
{
    return newData != self.data;
}

- (void)dataDidChanged
{
    Notice *obj = self.data;
    if (nil == obj) {
        return;
    }
    
    $(self.lblTitle).DATA(obj.title);
    [self setPriority:obj.priority];
    $(self.lblPublisher).DATA([NSString stringWithFormat:@"发布人: %@", obj.publisher]);
    $(self.lblPublishTime).DATA([NSString stringWithFormat:@"发布时间: %@", obj.publishTime]);
}

-(void) setPriority: (NSString*) priority {
    $(self.imgPriority).REMOVE_CLASS(@"low");
    $(self.imgPriority).REMOVE_CLASS(@"medium");
    $(self.imgPriority).REMOVE_CLASS(@"high");
    if ([priority eq:@"低"]) {
        $(self.imgPriority).ADD_CLASS(@"low");
    } else if ([priority eq:@"中"]) {
        $(self.imgPriority).ADD_CLASS(@"medium");
    } else if ([priority eq:@"高"]) {
        $(self.imgPriority).ADD_CLASS(@"high");
    }
    $(self.lblPriority).DATA(priority);
}



@end


