//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeNoticeListBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeNoticeListBoard_iPhone.h"
#import "GEToast.h"
#import "VankeUtil.h"
#import "PullLoader.h"
#import "FootLoader.h"
#import "NoDataCell_iPhoneCell.h"
#import "VankeNoticeBoard_iPhone.h"
#import "VankeNoticeListBoardCell_iPhone.h"

#define SEGMENT_UNREAD 0
#define SEGMENT_READED 1

#pragma mark -

@interface VankeNoticeListBoard_iPhone()
{
	//<#@private var#>
}
@end

@implementation VankeNoticeListBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_MODEL( VankeNoticeListModel, model )
DEF_OUTLET( BeeUISegmentedControl, segment )
DEF_OUTLET( BeeUIScrollView,     list )

- (void)load
{
    self.model = [VankeNoticeListModel modelWithObserver:self];
}

- (void)unload
{
    self.model = nil;
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    [UIApplication sharedApplication].statusBarHidden = NO;
    
    self.navigationBarShown = YES;
    self.title = @"公告";
    self.allowedSwipeToBack = YES;
    
    [self.segment addTitle:@"未读" tag: SEGMENT_UNREAD];
    [self.segment addTitle:@"已读" tag: SEGMENT_READED];
    self.segment.tintColor = [UIColor whiteColor];
    NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:[UIColor blackColor],NSForegroundColorAttributeName, nil];
    [self.segment setTitleTextAttributes:dic forState:UIControlStateSelected];
    NSDictionary *dic2 = [NSDictionary dictionaryWithObjectsAndKeys:[UIColor blackColor],NSForegroundColorAttributeName, nil];
    [self.segment setTitleTextAttributes:dic2 forState:UIControlStateNormal];
    self.segment.selectedTag = SEGMENT_UNREAD;
    
    self.list.headerClass = [PullLoader class];
    self.list.headerShown = YES;
    
    self.list.footerClass = [FootLoader class];
    self.list.footerShown = YES;
    
    self.list.lineCount = 1;
    self.list.animationDuration = 0.2f;
    self.list.baseInsets = bee.ui.config.baseInsets;
    
    self.list.whenReloading = ^
    {
        self.list.total = self.model.notices.count;
        if (self.model.loaded && self.list.total <= 0) {
            self.list.total = 1;
            BeeUIScrollItem * item = self.list.items[0];
            
            item.size = CGSizeMake( self.list.width, 50);
            item.order = 0;
            item.rule = BeeUIScrollLayoutRule_Fall;
            item.clazz = [NoDataCell_iPhoneCell class];
            item.data = @"没有数据，请稍后重试！";
        } else {
            for ( BeeUIScrollItem * item in self.list.items )
            {
                item.size = CGSizeMake( self.list.width, 80 );
                item.order = 0;
                item.rule = BeeUIScrollLayoutRule_Fall;
                item.clazz = [VankeNoticeListBoardCell_iPhone class];
                item.data = [self.model.notices safeObjectAtIndex:item.index];
            }
        }
    };
    self.list.whenReloaded = ^
    {
    };
    
    self.list.whenAnimated = ^
    {
    };
    self.list.whenScrolling = ^
    {
    };
    self.list.whenStop = ^
    {
    };
    self.list.whenHeaderRefresh = ^
    {
        [self.model firstPage];
    };
    self.list.whenFooterRefresh = ^
    {
        [self.model nextPage];
    };
    
    self.model.publishTimeBegin = @"";
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    self.navigationBarShown = YES;
    
    if ( NO == self.model.loaded )
    {
        [self.model firstPage];
    }
    
    UIColor *color = [VankeUtil rgbStringToColor: @"102,160,255"];
    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
    } else {
        self.navigationController.navigationBar.tintColor = color;
    }
    
    [BeeUIRouter sharedInstance].view.pannable = YES;
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = NO;
}

ON_DID_DISAPPEAR( signal )
{
}

ON_SIGNAL3( BeeUINavigationBar, LEFT_TOUCHED, signal )
{
}

ON_SIGNAL3( BeeUINavigationBar, RIGHT_TOUCHED, signal )
{
}

#pragma UISegmentedControl

ON_SIGNAL3( VankeNoticeListBoard_iPhone, segment, signal )
{
    NSLog(@"Seg.selectedSegmentTag:%d",self.segment.selectedTag);
     _model.readed = (_segment.selectedTag == 1);
    [_model firstPage];
}

#pragma mark VankeNoticeListBoardCell_iPhone

ON_SIGNAL3( VankeNoticeListBoardCell_iPhone, mask, signal )
{
    VankeNoticeBoard_iPhone *board = [VankeNoticeBoard_iPhone board];
    board.data = signal.sourceCell.data;
    [self.stack pushBoard:board animated:YES];
}

#pragma mark model

ON_SIGNAL3( VankeNoticeListModel, RELOADING, signal )
{
    [GEToast showProgress:self.view];
    self.list.headerLoading = YES;
    self.list.footerLoading = YES;
}

ON_SIGNAL3( VankeNoticeListModel, RELOADED, signal )
{
    [GEToast hideProgress];
    self.list.headerLoading = NO;
    self.list.footerLoading = NO;
    self.list.footerMore = self.model.more;
    [self.list reloadData];
}

@end
