//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementDetailListCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementDetailListCell_iPhone.h"
#import "VankeSettlementListAPI.h"

#pragma mark -

@implementation VankeStatementDetailListCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET(BeeUIImageView, imgPhoto)
DEF_OUTLET(BeeUILabel, lblName)
DEF_OUTLET(BeeUILabel, lblAmount)
DEF_OUTLET(BeeUILabel, lblDateRange)

- (void)load
{
}

- (void)unload
{
}

- (void)dataDidChanged
{
    SubjectItem *item = (SubjectItem*) self.data;
    if (!item) {
        return;
    }
    
    if ([item.direction intValue] < 0) {
        $(self.imgPhoto).DATA(@"money_reduce.png");
    } else {
        $(self.imgPhoto).DATA(@"money_add.png");
    }
    
    $(self.lblName).DATA(item.subject);
    $(self.lblAmount).DATA(item.amount.description);
    
    NSString *beginDate = [self trancateToDateString: item.beginDate];
    NSString *endDate = [self trancateToDateString: item.endDate];
    $(self.lblDateRange).DATA([NSString stringWithFormat:@"%@ 至 %@", beginDate, endDate]);
}

-(NSString*) trancateToDateString: (NSString*) dateTimeStr {
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSDate *date = [dateFormatter dateFromString:dateTimeStr];
    
    NSDateFormatter *dateFormatter2 = [[NSDateFormatter alloc] init];
    [dateFormatter2 setDateFormat:@"yyyy-MM-dd"];
    return [dateFormatter2 stringFromDate:date];
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

@end
