//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementDetailMonthCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementDetailMonthCell_iPhone.h"
#import "VankeSettlementListAPI.h"

#pragma mark -

@implementation VankeStatementDetailMonthCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUILabel,     lblYear )
DEF_OUTLET( BeeUILabel,     lblMonth )
DEF_OUTLET( BeeUILabel,     lblAmount )
DEF_OUTLET( BeeUILabel,     lblTotalPrefix )

- (void)load
{
    
}

- (void)unload
{
}

- (void)dataDidChanged
{
    StatementShop *shop = (StatementShop*) self.data;
    if (nil == shop) {
        return;
    }
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyyMM"];
    NSDate *settleDate = [dateFormatter dateFromString:shop.settle];
    [self setSettleDate:settleDate];
    $(self.lblAmount).DATA(shop.amount.description);
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

-(void) setSettleDate: (NSDate*) date {
    if (nil == date) {
        $(self.lblYear).DATA(@"");
        $(self.lblMonth).DATA(@"");
    } else {
        $(self.lblYear).DATA([NSString stringWithFormat:@"%lu", date.year]);
        $(self.lblMonth).DATA([NSString stringWithFormat:@"%lu", date.month]);
    }
}

@end

