//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementListBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementListBoard_iPhone.h"
#import "PullLoader.h"
#import "FootLoader.h"
#import "VankeUtil.h"
#import "GEToast.h"
#import "CDatePickerViewEx.h"
#import "NoDataCell_iPhoneCell.h"
#import "VankeStatementListItemCell_iPhone.h"
#import "VankeStatementDetailListBoard_iPhone.h"

#pragma mark -

@interface VankeStatementListBoard_iPhone()
{
	//<#@private var#>
}
@end

@implementation VankeStatementListBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

@synthesize shopLike = _shopLike;
@synthesize authorizedOrgUuidEquals = _authorizedOrgUuidEquals;

DEF_MODEL( VankeStatementListModel, model )
DEF_OUTLET( BeeUIScrollView,     list )
DEF_OUTLET( BeeUISearchBar,    searchBar)
DEF_OUTLET( VankeStatementMonthCell_iPhone, settlementBar)

- (void)load
{
    self.model = [VankeStatementListModel modelWithObserver:self];
}

- (void)unload
{
    self.model = nil;
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    [UIApplication sharedApplication].statusBarHidden = NO;
    self.navigationBarShown = YES;
    self.allowedSwipeToBack = YES;
    self.title = @"对账单";
    [self initListAndModel];
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    self.navigationBarShown = YES;
    if ( NO == self.model.loaded )
    {
        [self.model firstPage];
    }
    
    UIColor *color = [VankeUtil rgbStringToColor: @"144,76,245"];
    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
    } else {
        self.navigationController.navigationBar.tintColor = color;
    }
    [BeeUIRouter sharedInstance].view.pannable = YES;
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = NO;
}

ON_DID_DISAPPEAR( signal )
{
}

#pragma mark VankeStatementListBoard_iPhone

ON_SIGNAL3( VankeStatementListBoard_iPhone, searchBar, signal )
{
    NSString *nameLike = [VankeUtil trim:_searchBar.text];
    self.model.shopLike = nameLike;
    [self.model firstPage];
}

#pragma mark model

ON_SIGNAL3( VankeStatementListModel, RELOADING, signal )
{
    [GEToast showProgress:self.view];
    self.list.headerLoading = YES;
    self.list.footerLoading = YES;
}

ON_SIGNAL3( VankeStatementListModel, RELOADED, signal )
{
    [GEToast hideProgress];
    self.list.headerLoading = NO;
    self.list.footerLoading = NO;
    self.list.footerMore = self.model.more;
    [self.list reloadData];
    $(self.settlementBar).DATA(_model.lastResp);
}

#pragma VankeStatementMonthCell_iPhone

ON_SIGNAL3(VankeStatementMonthCell_iPhone, pickerMask, signal) {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"\n\n\n\n\n\n\n\n\n\n" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
//    CDatePickerViewEx *picker = [[CDatePickerViewEx alloc] init];
    UIDatePicker *picker = [[UIDatePicker alloc]init];
    [picker setDatePickerMode:UIDatePickerModeDate];
    [picker setLocale:[[NSLocale alloc]initWithLocaleIdentifier:@"zh_Hans_CN"]];
    if (nil != _settlementBar.settleDate) {
        [picker setDate:_settlementBar.settleDate];
    }
    [alertController.view addSubview:picker];
    [alertController addAction:({
        UIAlertAction *action = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {            
            // 立即设置账期
            self.model.settleEquals = picker.date;
            [self.model firstPage];
            
        }];
        action;
    })];
    [alertController addAction:({
        UIAlertAction *action = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
        action;
    })];
    
    UIPopoverPresentationController *popoverController = alertController.popoverPresentationController;
    popoverController.sourceView = self.view;
    popoverController.sourceRect = [self.view bounds];
    [self presentViewController:alertController animated:YES completion:nil];
}

#pragma VankeStatementListItemCell_iPhone

ON_SIGNAL3(VankeStatementListItemCell_iPhone, mask, signal) {
    StatementShop *cellValue = signal.sourceCell.data;
    VankeStatementDetailListBoard_iPhone *board = [VankeStatementDetailListBoard_iPhone board];
    board.data = cellValue;
    board.settleEquals = _model.settleEquals;
    board.authorizedOrgUuidEquals = _authorizedOrgUuidEquals;
    [self.stack pushBoard:board animated:YES];
}

#pragma private methods

-(void) initListAndModel {
    self.list.headerClass = [PullLoader class];
    self.list.headerShown = YES;
    
    self.list.footerClass = [FootLoader class];
    self.list.footerShown = YES;
    
    self.list.lineCount = 1;
    self.list.animationDuration = 0.2f;
    self.list.baseInsets = bee.ui.config.baseInsets;
    
    self.list.whenReloading = ^
    {
        self.list.total = self.model.shops.count;
        
        INFO(@"total = %d", self.model.shops.count);
        
        if (self.list.total <= 0) {
            self.list.total = 1;
            BeeUIScrollItem * item = self.list.items[0];
            
            item.size = CGSizeMake( self.list.width, 50);
            item.order = 0;
            item.rule = BeeUIScrollLayoutRule_Fall;
            item.clazz = [NoDataCell_iPhoneCell class];
            item.data = @"没有数据，请稍后重试！";
        } else {
            for ( BeeUIScrollItem *item in self.list.items )
            {
                item.size = CGSizeMake( self.list.width / self.list.lineCount, 70 );
                item.order = 0;
                item.rule = BeeUIScrollLayoutRule_Fall;
                item.clazz = [VankeStatementListItemCell_iPhone class];
                StatementShop *shop = [self.model.shops safeObjectAtIndex:item.index];
                item.data = shop;
            }
        }
    };
    self.list.whenReloaded = ^
    {
    };
    
    self.list.whenAnimated = ^
    {
    };
    self.list.whenScrolling = ^
    {
    };
    self.list.whenStop = ^
    {
    };
    self.list.whenHeaderRefresh = ^
    {
        [self.model firstPage];
    };
    self.list.whenFooterRefresh = ^
    {
        [self.model nextPage];
    };
    
    _model.shopLike = _shopLike;
    _model.projectsIn = [[NSArray alloc] initWithObjects:_authorizedOrgUuidEquals, nil];
    _model.settleEquals = [NSDate date];
}

@end
