//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementListItemCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementListItemCell_iPhone.h"
#import "VankeSettlementListAPI.h"

#pragma mark -

@implementation VankeStatementListItemCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET(BeeUIImageView, imgPhoto)
DEF_OUTLET(BeeUILabel, lblName)
DEF_OUTLET(BeeUIImageView, lblState)
DEF_OUTLET(BeeUILabel, lblAmount)
DEF_OUTLET(BeeUIImageView, imgState)

- (void)load
{
}

- (void)unload
{
}

- (void)dataDidChanged
{
    StatementShop *item = (StatementShop*) self.data;
    if (!item) {
        return;
    }
    
    $(self.imgPhoto).DATA([item getPictureUrlOrDefault]);
    $(self.lblName).DATA([item codeName]);
    $(self.lblState).DATA(@"已确认");
    $(self.lblAmount).DATA(item.amount.description);
    $(self.imgState).DATA([NSString stringWithFormat:@"%@.png", item.state]);
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

@end
