//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementMonthCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementMonthCell_iPhone.h"
#import "VankeSettlementListAPI.h"

#pragma mark -

@implementation VankeStatementMonthCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUILabel,     lblYear )
DEF_OUTLET( BeeUILabel,     lblMonth )
DEF_OUTLET( BeeUILabel,     lblCount )
DEF_OUTLET( BeeUILabel,     lblAmount )
DEF_OUTLET( BeeUILabel,     lblTotalPrefix )

@synthesize settleDate = _settleDate;

- (void)load
{
    
}

- (void)unload
{
}

- (void)dataDidChanged
{
    StatementListResponse *resp = (StatementListResponse*) self.data;
    if (nil == resp) {
        [self setSettleDate:[NSDate date]];
        $(self.lblCount).DATA(@"0");
        $(self.lblAmount).DATA(@"0");
        return;
    }
    
    [self setSettleDate:resp.settle];
    $(self.lblCount).DATA([NSString stringWithFormat:@"%d", [resp.data.paging.recordCount intValue]]);
    $(self.lblAmount).DATA(nil == resp.data.amount? @"0": resp.data.amount.description);
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

-(void) setSettleDate: (NSDate*) date {
    _settleDate = date;
    
    if (nil == date) {
        $(self.lblYear).DATA(@"");
        $(self.lblMonth).DATA(@"");
    } else {
        $(self.lblYear).DATA([NSString stringWithFormat:@"%lu", date.year]);
        $(self.lblMonth).DATA([NSString stringWithFormat:@"%lu", date.month]);
    }
}

@end

