//
//  UIColor+Helper.m
//  SAO
//
//  Created by Xummer on 14-3-20.
//  Copyright (c) 2014年 Xummer. All rights reserved.
//

#import "UIColor+Helper.h"

@implementation UIColor (Helper)

+ (UIColor *)colorWithR:(CGFloat)red g:(CGFloat)green b:(CGFloat)blue a:(CGFloat)alpha {
    return [UIColor colorWithRed:red/255.0f green:green/255.0f blue:blue/255.0f alpha:alpha];
}

+ (UIColor *)colorWithW:(CGFloat)white a:(CGFloat)alpha {
    return [UIColor colorWithWhite:white/255.0f alpha:alpha];
}

+ (UIColor *)colorFromHex:(int32_t)rgbValue {
    return [UIColor colorWithRed:((float)((rgbValue & 0xFF0000) >> 16))/255.0
                           green:((float)((rgbValue & 0xFF00) >> 8))/255.0
                            blue:((float)(rgbValue & 0xFF))/255.0 alpha:1.0];
}

@end
