//
//  ICRDatePickerViewController.m
//  Cruiser
//
//  Created by Xummer on 4/20/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTDatePickerViewController.h"
#import "IBTCommon.h"
#import "NSDate+FormatterAdditions.h"
#import "UIViewController+LogicController.h"

@interface IBTDatePickerViewController ()
@property (strong, nonatomic) UIDatePicker *datePicker;
@property (strong, nonatomic) NSDate *m_oSelectedDate;
@end

@implementation IBTDatePickerViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self setupSubviews];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillLayoutSubviews {
    [super viewWillLayoutSubviews];
    
    CGRect frame = _datePicker.frame;
    frame.origin.y = (CGRectGetHeight(self.view.bounds) - CGRectGetHeight(frame)) * (1 - 0.618);
    _datePicker.frame = frame;
}


#pragma mark - Public Method
- (void)setSelectedDate:(NSDate *)selectedDate {
    self.m_oSelectedDate = selectedDate;
}

#pragma mark - Private Method
- (void)setupSubviews {
    
    [self addRightBarBtnItemWithName:[IBTCommon localizableString:@"Done"]
                              action:@selector(onDoneButtonAction:)];
    
    self.datePicker = [[UIDatePicker alloc] init];
    _datePicker.datePickerMode = UIDatePickerModeDate;
    _datePicker.minimumDate = [NSDate date];
    if (self.m_oSelectedDate) {
        _datePicker.date = self.m_oSelectedDate;
    }
    
    [self.view addSubview:_datePicker];
}

#pragma mark - Actions
- (void)onDoneButtonAction:(__unused id)sender {
    if ([_delegate respondsToSelector:@selector(datePickerVCtrl:didSelectedDate:)]) {
        [_delegate datePickerVCtrl:self didSelectedDate:[_datePicker.date endOfTheDay]];
    }
}


@end
