//
//  ICRUIAppearance.m
//  Cruiser
//
//  Created by Xummer on 3/31/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRUIAppearance.h"
#import "IBTConstants.h"

@interface UILabel (Appearance)

@property (assign, nonatomic) UIColor *labelBackgroundColor UI_APPEARANCE_SELECTOR;

@end

@implementation UILabel (Appearance)
@dynamic labelBackgroundColor;

- (void)setLabelBackgroundColor:(UIColor *)labelBackgroundColor {
    [super setBackgroundColor:labelBackgroundColor];
}

@end

@implementation ICRUIAppearance

+ (void)CustomAppearance {
    if (IBT_IOS7_OR_LATER) {
        UIApplication.sharedApplication.delegate.window.tintColor =  [UIColor colorWithR:63 g:134 b:244 a:1];
    }
    
    [[self class] customNavigationbarAppearance];
    [[self class] customTabbarAppearance];
    [[self class] customLableAppearance];
}

+ (void)customNavigationbarAppearance {
    [UINavigationBar appearance].barTintColor =  [UIColor colorWithR:63 g:134 b:244 a:1];
    [UINavigationBar appearance].tintColor = [UIColor whiteColor];
    
    //Universal
    NSShadow *shadow = [[NSShadow alloc] init];
    shadow.shadowOffset = CGSizeZero;
    
    [[UINavigationBar appearance] setTitleTextAttributes:
     @{ NSForegroundColorAttributeName: [UIColor whiteColor],
        NSFontAttributeName: [UIFont boldSystemFontOfSize:20],
        NSShadowAttributeName: shadow}];

}

+ (void)customTabbarAppearance {
    if (IBT_IOS7_OR_LATER) {
        [[UITabBar appearance] setBarTintColor:[UIColor colorWithR:36 g:38 b:53 a:1]];
    }
    else {
        [[UITabBar appearance] setTintColor:[UIColor colorWithR:36 g:38 b:53 a:1]];
    }
    
    UIImage *selTab = [[UIImage imageNamed:@"TabbarSelectedBG"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    CGSize tabSize = CGSizeMake(IBT_MAIN_SCREEN_WIDTH/4, 49);
    UIGraphicsBeginImageContext(tabSize);
    [selTab drawInRect:CGRectMake(0, 0, tabSize.width, tabSize.height)];
    UIImage *reSizeImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    [[UITabBar appearance] setSelectionIndicatorImage:reSizeImage];
}

+ (void)customLableAppearance {
    
    if (IBT_IOS7_OR_LATER) {
        
    }
    else {
        [[UILabel appearance] setLabelBackgroundColor:[UIColor clearColor]];
    }
}


@end
