//
//  ICRAttachmentUnit.m
//  Cruiser
//
//  Created by Xummer on 4/19/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRAttachmentUnit.h"
#import "UIColor+Helper.h"
#import "UIImageView+WebCache.h"

#define IBT_ATTACH_IMAGE_CORNER_RADIUS          (4)
#define IBT_ATTACH_TOP_PADDING                  (10)
#define IBT_ATTACH_AUDIO_HEIGHT                 (30)

@interface ICRAttachmentUnit ()
{
    AttachmentUnitType m_eCurAttachType;
}
@property (strong, nonatomic) UIImageView *m_imageView;
@property (strong, nonatomic) UILabel *m_titleLabel;
@property (strong, nonatomic) UIImageView *m_iconMask;
@end

@implementation ICRAttachmentUnit

#pragma mark - Life Cycle
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubviews];
    
    return self;
}

- (void)didMoveToSuperview {
    [super didMoveToSuperview];
    
    if (self.superview) {
        [self bringSubviewToFront:_m_titleLabel];
        
        [self.superview addSubview:_m_closeButton];
    }
}

- (void)removeFromSuperview {
    [_m_closeButton removeFromSuperview];
    
    [super removeFromSuperview];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    _m_titleLabel.hidden = [_m_titleLabel.text length] == 0;
    
    if (_m_eCurFileType == kICRTypeAudio) {
        _m_imageView.frame = (CGRect){
            .origin.x = 0,
            .origin.y = IBT_ATTACH_TOP_PADDING,
            .size.width = IBT_ATTACH_UNIT_DEFAULT_WIDTH + 20,
            .size.height = IBT_ATTACH_AUDIO_HEIGHT
        };
        
        _m_titleLabel.frame = (CGRect){
            .origin.x = 0,
            .origin.y = 0,
            .size.width = IBT_ATTACH_UNIT_DEFAULT_WIDTH - 10,
            .size.height = IBT_ATTACH_AUDIO_HEIGHT
        };
        
        CGFloat h = 16;
        _m_iconMask.frame = (CGRect){
            .origin.x = CGRectGetMaxX(_m_titleLabel.frame),
            .origin.y = (CGRectGetHeight(_m_imageView.bounds) - h) * .5f,
            .size.width = h,
            .size.height = h
        };
        
        _m_iconMask.layer.cornerRadius = 0;
    }
    else {
        _m_imageView.frame = (CGRect){
            .origin.x = 0,
            .origin.y = IBT_ATTACH_TOP_PADDING,
            .size.width = IBT_ATTACH_UNIT_DEFAULT_WIDTH,
            .size.height = IBT_ATTACH_UNIT_DEFAULT_WIDTH
        };
        
        _m_iconMask.frame = _m_imageView.bounds;
        
        CGFloat h = IBT_ATTACH_UNIT_TITLE_HEIGHT - 10;
        CGFloat dy = 10;
        switch (_m_eCurDisplayType) {
            case kATTDisplayOutTitle:
            {
                dy = CGRectGetMaxY(_m_imageView.frame);
            }
                break;
            case kATTDisplayInnerTitle:
            {
                dy = CGRectGetHeight(_m_imageView.bounds) - h;
            }
                break;
            default:
                break;
        }
        
        _m_titleLabel.frame = (CGRect){
            .origin.x = 0,
            .origin.y = dy,
            .size.width = CGRectGetWidth(_m_imageView.bounds),
            .size.height = h
        };
        
        _m_iconMask.layer.cornerRadius = _m_imageView.layer.cornerRadius;
    }
    
    CGFloat w = 22;
    CGFloat delta = - (1 - 0.618f) * w;
    _m_closeButton.frame = (CGRect){
        .origin.x = CGRectGetMaxX(self.frame) - 0.618f * w,
        .origin.y = CGRectGetMinY(self.frame) + CGRectGetMinY(_m_imageView.frame) + delta ,
        .size.width = w,
        .size.height = w
    };
}

#pragma mark - Setter
- (void)setM_eCurDisplayType:(AttachmentDisplayType)eCurDisplayType {
    if (_m_eCurDisplayType == eCurDisplayType) {
        return;
    }
    
    _m_eCurDisplayType = eCurDisplayType;
    
    switch (_m_eCurDisplayType) {
        case kATTDisplayOutTitle:
        {
            self.m_titleLabel.backgroundColor = [UIColor clearColor];
            self.m_titleLabel.textColor = [UIColor grayColor];
            [self addSubview:_m_titleLabel];
        }
            break;
        case kATTDisplayInnerTitle:
        {
            if (_m_eCurFileType == kICRTypeAudio) {
                self.m_titleLabel.backgroundColor = [UIColor clearColor];
            }
            else {
                self.m_titleLabel.backgroundColor = [UIColor colorWithW:1 a:.8];
            }
            
            self.m_titleLabel.textColor = [UIColor whiteColor];
            [self.m_imageView addSubview:_m_titleLabel];
        }
            break;
        default:
            break;
    }
    
    [self setNeedsLayout];
}

#pragma mark - Public Method
- (void)updateWithType:(AttachmentUnitType)type
                masker:(UIImage *)masker
           placeHolder:(UIImage *)phImage
                 image:(id)image
                 title:(NSString *)title
{
    BOOL haveCloseBtn = NO;
    switch (type) {
        case kATTNormal:
        {
            haveCloseBtn = NO;
        }
            break;
        case kATTCloseBtn:
        {
            haveCloseBtn = YES;
        }
            break;
            
        default:
            break;
    }
    
    _m_closeButton.hidden = !haveCloseBtn;
    self.clipsToBounds = _m_closeButton.hidden;
    self.highLightWhenTapped = _m_iconMask.hidden;
    self.m_iconMask.image = masker;
    
    if ([image isKindOfClass:[UIImage class]]) {
        _m_imageView.image = image;
    }
    else if ([image isKindOfClass:[NSURL class]]) {
        [_m_imageView sd_setImageWithURL:image placeholderImage:phImage];
    }
    else {
        _m_imageView.image = phImage;
    }
    
    _m_titleLabel.text = title;
    
    switch (_m_eCurDisplayType) {
        case kATTDisplayInnerTitle:
        {
            if (_m_eCurFileType == kICRTypeAudio) {
                self.m_titleLabel.backgroundColor = [UIColor clearColor];
            }
            else {
                self.m_titleLabel.backgroundColor = [UIColor colorWithW:1 a:.8];
            }
        }
            break;
            
        default:
            break;
    }
}

#pragma mark - Private Method
- (void)initSubviews {
    self.backgroundColor = [UIColor clearColor];
    self.highLightWhenTapped = YES;
    
    self.m_imageView = [[UIImageView alloc] init];
    _m_imageView.layer.cornerRadius = IBT_ATTACH_IMAGE_CORNER_RADIUS;
    _m_imageView.layer.masksToBounds = YES;
    [self addSubview:_m_imageView];
    
    self.m_iconMask = [[UIImageView alloc] init];
    _m_iconMask.layer.masksToBounds = YES;
    _m_iconMask.contentMode = UIViewContentModeCenter;
    [_m_imageView addSubview:_m_iconMask];
    
    self.m_titleLabel = [[UILabel alloc] init];
    _m_titleLabel.textColor = [UIColor grayColor];
    _m_titleLabel.textAlignment = NSTextAlignmentCenter;
    _m_titleLabel.font = [UIFont systemFontOfSize:12];
    [self addSubview:_m_titleLabel];
    
    self.m_closeButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [_m_closeButton setImage:[UIImage imageNamed:@"attachment_delete_btn"]
                  forState:UIControlStateNormal];
    self.m_closeButton.hidden = YES;
}

@end
