//
//  IBTUISearchBar.m
//  Cruiser
//
//  Created by Lili Wang on 15/4/10.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTUISearchBar.h"

@interface IBTUISearchBar ()
<
UISearchBarDelegate
>

@end

@implementation IBTUISearchBar

#pragma mark - Life Cycle
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self _m_init];
    }
    return self;
}

#pragma mark - Private Method
- (void)_m_init {
    self.delegate = self;
}

#pragma mark - UISearchBarDelegate
- (BOOL)searchBarShouldBeginEditing:(UISearchBar *)searchBar {
    if ([_sbDelegate respondsToSelector:@selector(searchBarShouldBeginEditing:)]) {
        return [_sbDelegate searchBarShouldBeginEditing:searchBar];
    }
    
    return YES;
}

- (void)searchBarTextDidBeginEditing:(UISearchBar *)searchBar {
    _isSearching = YES;
    
    if ([_sbDelegate respondsToSelector:@selector(searchBarTextDidBeginEditing:)]) {
        [_sbDelegate searchBarTextDidBeginEditing:searchBar];
    }
}

- (BOOL)searchBarShouldEndEditing:(UISearchBar *)searchBar{
    if ([_sbDelegate respondsToSelector:@selector(searchBarShouldEndEditing:)]) {
        return [_sbDelegate searchBarShouldEndEditing:searchBar];
    }
    
    return YES;
}

- (void)searchBarTextDidEndEditing:(UISearchBar *)searchBar {
    if ([_sbDelegate respondsToSelector:@selector(searchBarTextDidEndEditing:)]) {
        [_sbDelegate searchBarTextDidEndEditing:searchBar];
    }
}

- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText {
    if ([_sbDelegate respondsToSelector:@selector(searchBar:textDidChange:)]) {
        [_sbDelegate searchBar:searchBar textDidChange:searchText];
    }
}

- (BOOL)searchBar:(UISearchBar *)searchBar shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    if ([_sbDelegate respondsToSelector:@selector(searchBar:shouldChangeTextInRange:replacementText:)]) {
        return [_sbDelegate searchBar:searchBar shouldChangeTextInRange:range replacementText:text];
    }
    
    return YES;
}

- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar {
    _isSearching = YES;
    
    if ([_sbDelegate respondsToSelector:@selector(searchBarSearchButtonClicked:)]) {
        [_sbDelegate searchBarSearchButtonClicked:searchBar];
    }
}

- (void)searchBarBookmarkButtonClicked:(UISearchBar *)searchBar {
    if ([_sbDelegate respondsToSelector:@selector(searchBarBookmarkButtonClicked:)]) {
        [_sbDelegate searchBarBookmarkButtonClicked:searchBar];
    }
}

- (void)searchBarCancelButtonClicked:(UISearchBar *) searchBar {
    _isSearching = NO;
    
    if ([_sbDelegate respondsToSelector:@selector(searchBarCancelButtonClicked:)]) {
        [_sbDelegate searchBarCancelButtonClicked:searchBar];
    }
}

- (void)searchBarResultsListButtonClicked:(UISearchBar *)searchBar {
    if ([_sbDelegate respondsToSelector:@selector(searchBarResultsListButtonClicked:)]) {
        [_sbDelegate searchBarResultsListButtonClicked:searchBar];
    }
}

- (void)searchBar:(UISearchBar *)searchBar selectedScopeButtonIndexDidChange:(NSInteger)selectedScope {
    if ([_sbDelegate respondsToSelector:@selector(searchBar:selectedScopeButtonIndexDidChange:)]) {
        [_sbDelegate searchBar:searchBar selectedScopeButtonIndexDidChange:selectedScope];
    }
}

@end
