//
//  VankeNoticeListAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeBaseAPI.h"
#import "VankeResponse.h"

@class NoticeListResponse;


/*
 * 查询项目列表
 *http://.../wanke-server/rest/affiche/download/{user_uuid}?read={read}&page_number={pageNumber}&page_size={pageSize}
 */
@interface VankeNoticeListAPI : VankeBaseAPI

// 是否已读
@property (nonatomic, assign) BOOL read;
@property (nonatomic, assign) NSUInteger pageNumber;
@property (nonatomic, assign) NSUInteger pageSize;

@end

// 公告信息
@interface Notice : BeeActiveObject

// 标识
@property (nonatomic, strong) NSString *uuid;
// 版本
@property (nonatomic, strong) NSNumber *version;
// 发布时间
@property (nonatomic, strong) NSString *create_time;
// 发布人
@property (nonatomic, strong) NSString *create_id;
// 发布人
@property (nonatomic, strong) NSString *create_operName;
@property (nonatomic, strong) NSString *lastModify_time;
@property (nonatomic, strong) NSString *lastModify_id;
@property (nonatomic, strong) NSString *lastModify_operName;
@property (nonatomic, strong) NSString *enterprise;
// 标题
@property (nonatomic, strong) NSString *title;
// 内容
@property (nonatomic, strong) NSString *content;
// 优先级
@property (nonatomic, strong) NSNumber *priority;
// 状态
@property (nonatomic, strong) NSNumber *state;
// 附件
@property (nonatomic, strong) NSString *attachment;

-(NSString*) getAttachmentUrl;

@end

// 返回数据
@interface NoticeListResponseData : BeeActiveObject

@property (nonatomic, strong) Paging *paging;
@property (nonatomic, strong) NSArray *records; //Notice

@end

// 请求响应
@interface NoticeListResponse : VankeResponse

@property (nonatomic, strong) NoticeListResponseData *data;

-(NSInteger) total;

@end