

#import "VankeMainTabBoard_iPhone.h"
#import "VankeCommonModel.h"

NSString *const MAIN_TAB_NAME_HOME = @"home";     // home
NSString *const MAIN_TAB_NAME_AFFAIRS = @"affairs";  // affairs
NSString *const MAIN_TAB_NAME_ME = @"me";       // me

#pragma mark -

@interface VankeMainTabBoard_iPhone()
{
	//<#@private var#>
}
@end

@implementation VankeMainTabBoard_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIButton, home );
DEF_OUTLET( BeeUIButton, affairs );
DEF_OUTLET( BeeUIButton, me );

- (void)load
{
}

- (void)unload
{
}

- (void)dataDidChanged {
}

- (void)selectHome
{
    [self removeActiveClass];
    [self addActiveClass:$(self.home) relayout:YES];
}

- (void)selectAffairs
{
    [self removeActiveClass];
    [self addActiveClass:$(self.affairs) relayout:YES];
}

- (void)selectMe
{
    [self removeActiveClass];
    [self addActiveClass:$(self.me) relayout:YES];
}

- (void) removeActiveClass {
    $(self.home).REMOVE_CLASS( @"active" );
    $(self.affairs).REMOVE_CLASS( @"active" );
    $(self.me).REMOVE_CLASS( @"active" );
}

- (void) addActiveClass: (BeeUIQuery*) activeItem relayout: (BOOL) relayout {
    activeItem.ADD_CLASS( @"active" );
    if (relayout) {
        self.RELAYOUT();
    }
}

-(NSString*) showAndSelectFirst {
    if ([self.home visible]) {
        [self selectHome];
        return MAIN_TAB_NAME_HOME;
    } else if ([self.affairs visible]) {
        [self selectAffairs];
        return MAIN_TAB_NAME_AFFAIRS;
    } else {
        [self selectMe];
        return MAIN_TAB_NAME_ME;
    }
}

-(void) hideTab: (NSString*) tabName visible: (BOOL) visible {
    if (visible) {
        $(tabName).SHOW();
    } else {
        $(tabName).HIDE();
    }
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, home, signal )
{
    [self selectHome];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, affairs, signal )
{
    [self selectAffairs];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, me, signal )
{
    [self selectMe];
}

@end
