//
//  ICRAboutViewController.m
//  Cruiser
//
//  Created by Lili Wang on 15/4/8.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define IBT_APP_ICON_WIDTH     (80)

#import "ICRAboutViewController.h"
#import "VankeUtil.h"

@interface ICRAboutViewController ()

@property (strong, nonatomic) IBTTableViewInfo *m_tableViewInfo;
@property (strong, nonatomic) UIImageView *m_viewAvatarImage;
@property (strong, nonatomic) IBTTableViewCellInfo *phoneCellInfo;

@end

@implementation ICRAboutViewController

ON_CREATE_VIEWS( signal )
{
}

//- (void)viewDidLoad {
//    [super viewDidLoad];
//    // Do any additional setup after loading the view.
//    [self initTableViewInfo];
//}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initTableViewInfo {
    self.title = [IBTCommon localizableString:@"About"];
    
    CGRect bounds = self.view.bounds;
    bounds.origin.y = 64;
    self.m_tableViewInfo = [[IBTTableViewInfo alloc] initWithFrame:bounds style:UITableViewStyleGrouped];
    
    IBTTableView *tableV = [_m_tableViewInfo getTableView];
    [self.view addSubview:tableV];
    
    IBTUIView *tableHeader = [[IBTUIView alloc] init];
    tableHeader.backgroundColor = [UIColor clearColor];
    tableHeader.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = tableV.width,
        .size.height = 160
    };
    
    CGFloat fNameH = 40;
    self.m_viewAvatarImage = [[UIImageView alloc] init];
    _m_viewAvatarImage.frame = (CGRect){
        .origin.x = (self.view.width - IBT_APP_ICON_WIDTH) * .5f,
        .origin.y = (tableHeader.height - IBT_APP_ICON_WIDTH - fNameH) * IBT_GOLDEN_RATIO,
        .size.width = IBT_APP_ICON_WIDTH,
        .size.height = IBT_APP_ICON_WIDTH
    };
    _m_viewAvatarImage.layer.cornerRadius = IBT_APP_ICON_WIDTH / 10;
    _m_viewAvatarImage.layer.masksToBounds = YES;
    
    CGFloat fMargin = 10;
    UILabel *appNameLabel = [[UILabel alloc] init];
    appNameLabel.frame = (CGRect){
        .origin.x = fMargin,
        .origin.y = _m_viewAvatarImage.bottom,
        .size.width = tableHeader.width - 2 * fMargin,
        .size.height = fNameH
    };
    
    appNameLabel.font = [UIFont boldSystemFontOfSize:18];
    appNameLabel.textColor = IBT_TINTCOLOR;
    appNameLabel.textAlignment = NSTextAlignmentCenter;
    
    [tableHeader addSubview:_m_viewAvatarImage];
    [tableHeader addSubview:appNameLabel];
    
    tableV.tableHeaderView = tableHeader;
    
    
    // Footer
    CGRect frame = self.view.frame;
    frame.size.height = 20;
    frame.origin.y = self.view.height - CGRectGetHeight(frame) -20;
    
    UILabel *label = [[UILabel alloc] initWithFrame:frame];
    label.font = [UIFont systemFontOfSize:16];
    label.text = @"Copyright@2015";
    label.backgroundColor = [UIColor clearColor];
    label.textAlignment = NSTextAlignmentCenter;
    label.autoresizingMask = UIViewAutoresizingFlexibleTopMargin;
    
    //tableV.tableFooterView = label;
    [self.view addSubview:label];
    
    /*
     CFBundleIcons =     {
     CFBundlePrimaryIcon =         {
     CFBundleIconFiles =             (
     AppIcon29x29,
     AppIcon40x40,
     AppIcon57x57,
     AppIcon60x60,
     AppIcon120x120
     );
     };
     };
     */
    
    NSArray *arrIcons = [[NSBundle mainBundle] infoDictionary][ @"CFBundleIcons" ][ @"CFBundlePrimaryIcon" ][ @"CFBundleIconFiles" ];
    UIImage *appIcon = nil;
    NSUInteger uiIconCount = [arrIcons count];
    for (NSInteger i = uiIconCount - 1; i >= 0; i -- ) {
        appIcon = [UIImage imageNamed:arrIcons[ i ]];
        if (appIcon) {
            break;
        }
    }
    
    _m_viewAvatarImage.image = appIcon;
    appNameLabel.text = IBT_APP_NAME_STR;
    
    // Section 0
    IBTTableViewSectionInfo *sec0Info = [IBTTableViewSectionInfo sectionInfoDefaut];
    
    // Version
//#if DEBUG
//    NSString *nsBuild = IBT_APP_BUILD_STR;
//    NSString *nsVersion = IBT_APP_VERSION_STR;
//    NSString *nsV = (nsBuild.length > 0) ? [NSString stringWithFormat:@"%@(%@)", nsVersion, nsBuild] : nsVersion;
//#else
//    NSString *nsV = IBT_APP_VERSION_STR;
//#endif
    
    NSString *nsV = [[VankeUtil getCurrentVersion] toString];
    IBTTableViewCellInfo *versionCellInfo =
    [IBTTableViewCellInfo normalCellForSel:nil target:nil
                                    title:[IBTCommon localizableString:@"Version"]
                               rightValue:nsV
                            accessoryType:UITableViewCellAccessoryNone];
    versionCellInfo.selectionStyle = UITableViewCellSelectionStyleNone;
    [sec0Info addCell:versionCellInfo];

    
    self.phoneCellInfo = [IBTTableViewCellInfo normalCellForSel:@selector(onShowHelpAndFeedBackView:) target:self
                                     title:[IBTCommon localizableString:@"Phone Number"]
                                rightValue:@"400-400-4000"
                             accessoryType:UITableViewCellAccessoryNone];
    [sec0Info addCell:_phoneCellInfo];
    
    [_m_tableViewInfo addSection:sec0Info];
}

ON_LAYOUT_VIEWS( signal )
{
    if (nil == self.m_tableViewInfo) {
        [self initTableViewInfo];
    }
    
}

- (void)onShowHelpAndFeedBackView:(__unused id)sender {
    NSString *phoneNumber = [_phoneCellInfo getUserInfoValueForKey:CInfoRightValueKey];
    NSURL *phoneUrl = [NSURL URLWithString:[@"telprompt://" stringByAppendingString:phoneNumber]];
    NSURL *phoneFallbackUrl = [NSURL URLWithString:[@"tel://" stringByAppendingString:phoneNumber]];
    
    if ([UIApplication.sharedApplication canOpenURL:phoneUrl]) {
        [UIApplication.sharedApplication openURL:phoneUrl];
    } else if ([UIApplication.sharedApplication canOpenURL:phoneFallbackUrl]) {
        [UIApplication.sharedApplication openURL:phoneFallbackUrl];
    } else {
        // Show an error message: Your device can not do phone calls.
    }
}

@end
