//
//  ICRAttachTitleView.m
//  Cruiser
//
//  Created by Xummer on 15/4/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRAttachTitleView.h"

#define AT_VERTICAL_MARGIN      (10.0f)
#define AT_HORIZON_MARGIN       (10.0f)

@interface ICRAttachTitleView ()
@property (strong, nonatomic) UIImageView *m_icon;
@property (strong, nonatomic) IBTUILabel *m_titleLabel;
@end

@implementation ICRAttachTitleView

#pragma mark - Life Cycle
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubviews];
    
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat fDy = AT_HORIZON_MARGIN;
    CGFloat fW = self.width - 2 * fDy;
    _m_icon.frame = (CGRect){
        .origin.x = fDy,
        .origin.y = 0,
        .size.width = fW,
        .size.height = fW
    };
    
    _m_titleLabel.frame = (CGRect){
        .origin.x = 0,
        .origin.y = _m_icon.bottom,
        .size.width = self.width,
        .size.height = 16
    };
}

#pragma mark - Private Method
- (void)initSubviews {
    
    self.backgroundColor = [UIColor clearColor];
    
    self.m_icon = [[UIImageView alloc] init];
    [self addSubview:_m_icon];
    
    self.m_titleLabel = [[IBTUILabel alloc] init];
    _m_titleLabel.textAlignment = NSTextAlignmentCenter;
    _m_titleLabel.textColor = [UIColor lightGrayColor];
    _m_titleLabel.font = [UIFont systemFontOfSize:12.0f];
    [self addSubview:_m_titleLabel];
}

@end

@implementation ICRAttachTitleView (Configure)

- (void)updateWithTitle:(NSString *)title iconName:(NSString *)iconName {
    self.m_titleLabel.text = title;
    self.m_icon.image = [UIImage imageNamed:iconName];
}

@end
