//
//  VankeVersionAPI.h
//  vanke
//
//  Created by xiaomi on 15/11/12.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeBaseAPI.h"
#import "VankeUtil.h"

@class VersionInfo;
@class VersionResponse;

@interface VankeVersionAPI : VankeBaseAPI

@end

// 版本信息
@interface VersionInfo: BeeActiveObject

// 版本标识
@property (nonatomic, strong) NSString *uuid;

// 版本类型
@property (nonatomic, strong) NSString *type;

// 版本号
@property (nonatomic, strong) NSString *version;

// 版本下载 url
@property (nonatomic, strong) NSString *url;

// 是否强制下载 
@property (nonatomic, strong) NSString *forceUpdate;

@end

// 响应
@interface VersionResponse : VankeResponse

@property (nonatomic, strong) VersionInfo *data;

/**
 *  最新版本
 *
 *  @return 如果没有更新版本，则返回nil
 */
-(VersionNumber*) newVersion;

/**
 *  是否强制更新
 *
 *  @return 是否强制更新
 */
-(BOOL) isForceUpdate;

@end
