#import "Bee.h"
#import "VankeFloorListBoardCell_iPhone.h"
#import "VankeProjectListModel.h"
#import "VankeBaseBoard.h"

#pragma mark -

typedef enum {
    CELL_TYPE_FLOOR = 0,
    CELL_TYPE_PASSENGER
} CellType;

@interface VankeFloorListBoard_iPhone : VankeBaseBoard

AS_MODEL( VankeProjectListModel, model );

AS_OUTLET( BeeUIScrollView,     list );
AS_OUTLET( BeeUISearchBar,    searchBar);

@property (assign, nonatomic) CellType listType;

// 项目分类名称
@property (strong, nonatomic) NSString *projectCategory;
// 项目名称类似
@property (strong, nonatomic) NSString *projectNameLike;
// 销售日期
@property (strong, nonatomic) NSString *salesDate;

+ (id)boardWithType: (CellType) type;

@end
