

#import "VankeFloorListBoard_iPhone.h"
#import "PullLoader.h"
#import "FootLoader.h"
#import "VankeUtil.h"
#import "GEToast.h"
#import "NoDataCell_iPhoneCell.h"
#import "VankeProjectListAPI.h"
#import "VankeFloorDetailBoard_iPhone.h"
#import "VankeFloorListBoardCell_iPhone.h"
#import "VankePassengerDetailBoard_iPhone.h"
#import "VankePassengerListBoardCell_iPhone.h"

@interface VankeFloorListBoard_iPhone () <UISearchBarDelegate>
@end

#pragma mark -

@implementation VankeFloorListBoard_iPhone
{
}

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

@synthesize projectCategory = _projectCategory;
@synthesize projectNameLike = _projectNameLike;
@synthesize salesDate = _salesDate;
@synthesize listType = _listType;

DEF_MODEL( VankeProjectListModel, model );
DEF_OUTLET( BeeUIScrollView, list );
DEF_OUTLET( BeeUISearchBar,    searchBar);

+ (id)boardWithType: (CellType) type {
    VankeFloorListBoard_iPhone *board = [super board];
    board.listType = type;
    return board;
}

- (void)load
{
    self.model = [VankeProjectListModel modelWithObserver:self];
}

- (void)unload
{
    self.model = nil;
}

#pragma mark -

ON_CREATE_VIEWS( signal )
{
    [UIApplication sharedApplication].statusBarHidden = NO;
    
    self.navigationBarShown = YES;
    self.title = _projectCategory;
    
    self.allowedSwipeToBack = YES;
    
    self.list.headerClass = [PullLoader class];
    self.list.headerShown = YES;
    
    self.list.footerClass = [FootLoader class];
    self.list.footerShown = YES;
    
    self.list.lineCount = 2;
    self.list.animationDuration = 0.2f;
    self.list.baseInsets = bee.ui.config.baseInsets;
    
    self.list.whenReloading = ^
    {
        self.list.total = self.model.projects.count;
        if (self.model.loaded && self.list.total <= 0) {
            self.list.total = 1;
            BeeUIScrollItem * item = self.list.items[0];
            
            item.size = CGSizeMake( self.list.width, 100 );
            item.order = 0;
            item.rule = BeeUIScrollLayoutRule_Fall;
            item.clazz = [NoDataCell_iPhoneCell class];
            item.data = @"没有数据，请稍后重试！";
        } else {
            CGFloat cellHeight = 240;
            if (self.listType == CELL_TYPE_PASSENGER) {
                cellHeight = 200;
            }
            
            for ( BeeUIScrollItem * item in self.list.items )
            {
                item.size = CGSizeMake( self.list.width / self.list.lineCount, cellHeight );
                item.order = 0;
                item.rule = BeeUIScrollLayoutRule_Fall;
                if (self.listType == CELL_TYPE_PASSENGER) {
                    item.clazz = [VankePassengerListBoardCell_iPhone class];
                } else {
                    item.clazz = [VankeFloorListBoardCell_iPhone class];
                }
                
                ProjectCategory *prj = [self.model.projects safeObjectAtIndex:item.index];
                FloorCellValue *cellValue = [[FloorCellValue alloc] init];
                cellValue.theme = self.theme;
                cellValue.project = prj;
                item.data = cellValue;
            }
        }
    };
    self.list.whenReloaded = ^
    {
    };
    
    self.list.whenAnimated = ^
    {
    };
    self.list.whenScrolling = ^
    {
    };
    self.list.whenStop = ^
    {
    };
    self.list.whenHeaderRefresh = ^
    {
        [self.model firstPage];
    };
    self.list.whenFooterRefresh = ^
    {
        [self.model nextPage];
    };
    
    self.model.classificationEquals = _projectCategory;
    self.model.nameLike = _projectNameLike;
    self.model.salesDateEquals = _salesDate;
    _searchBar.text = _projectNameLike;
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
//    _searchBar.frame = _searchView.frame;
}

ON_WILL_APPEAR( signal )
{
    self.navigationBarShown = YES;
    //    [self.list reloadData];
    
    if ( NO == self.model.loaded )
    {
        [self.model firstPage];
    }
    
    [BeeUIRouter sharedInstance].view.pannable = YES;
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
    [BeeUIRouter sharedInstance].view.pannable = NO;
}

ON_DID_DISAPPEAR( signal )
{
}

#pragma mark VankeFloorListBoard_iPhone

ON_SIGNAL3( VankeFloorListBoard_iPhone, searchBar, signal )
{
    NSString *nameLike = [VankeUtil trim:_searchBar.text];
    self.model.nameLike = nameLike;
    [self.model firstPage];
}

#pragma mark VankeFloorListBoardCell_iPhone

ON_SIGNAL3( VankeFloorListBoardCell_iPhone, mask, signal )
{
    FloorCellValue *cellValue = signal.sourceCell.data;
    [self showDetailView:cellValue];
}

#pragma mark VankePassengerListBoardCell_iPhone

ON_SIGNAL3( VankePassengerListBoardCell_iPhone, mask, signal )
{
    FloorCellValue *cellValue = signal.sourceCell.data;
    [self showDetailView:cellValue];
}

-(void) showDetailView: (FloorCellValue*) cellValue  {
    if (self.listType == CELL_TYPE_PASSENGER) {
        VankePassengerDetailBoard_iPhone * board = [VankePassengerDetailBoard_iPhone board];
        board.data = cellValue.project;
        board.passengerFlowDate = _salesDate;
        board.theme = self.theme;
        [self.stack pushBoard:board animated:YES];
    } else {
        VankeFloorDetailBoard_iPhone *board = [VankeFloorDetailBoard_iPhone board];
        board.data = cellValue.project;
        board.salesDate = _salesDate;
        board.theme = self.theme;
        [self.stack pushBoard:board animated:YES];
    }
}

#pragma mark model

ON_SIGNAL3( VankeProjectListModel, RELOADING, signal )
{
    [GEToast showProgress:self.view];
    self.list.headerLoading = YES;
    self.list.footerLoading = YES;
}

ON_SIGNAL3( VankeProjectListModel, RELOADED, signal )
{
    [GEToast hideProgress];
    self.list.headerLoading = NO;
    self.list.footerLoading = NO;
    self.list.footerMore = self.model.more;
    [self.list reloadData];
}

#pragma UISearchBarDelegate

-(void) searchBarSearchButtonClicked:(UISearchBar *)searchBar {    
    NSString *nameLike = [VankeUtil trim:_searchBar.text];
    self.model.nameLike = nameLike;
    [self.model firstPage];
}


@end
