

#import "VankePassengerListBoardCell_iPhone.h"
#import "VankeUtil.h"

#pragma mark -

@implementation VankePassengerListBoardCell_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIImageView,     imgPhoto )
DEF_OUTLET( BeeUILabel,         lblName )
DEF_OUTLET( BeeUILabel,         lblOpenDate )
DEF_OUTLET( BeeUILabel,         lblSaleAmount )

- (BOOL)dataWillChange:(id)newData
{
    return newData != self.data;
}

- (void)dataDidChanged
{
    FloorCellValue * obj = self.data;
    if (nil == obj) {
        return;
    }
    
    ProjectCategory *prj = obj.project;
    if ( prj )
    {
        self.lblName.data = prj.projectName;
        self.imgPhoto.data = [prj getPictureUrlOrDefault];
        self.lblOpenDate.data = prj.foundingDate;
        self.lblSaleAmount.data = prj.salesAmount;
        $(self.lblSaleAmount).ADD_CLASS(obj.theme);
    }
}

@end


