//
//	 ______    ______    ______
//	/\  __ \  /\  ___\  /\  ___\
//	\ \  __<  \ \  __\_ \ \  __\_
//	 \ \_____\ \ \_____\ \ \_____\
//	  \/_____/  \/_____/  \/_____/
//
//	Powered by BeeFramework
//
//
//  VankeNoticeBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeNoticeBoard_iPhone.h"
#import "VankeUtil.h"
#import "VankeBaseAPI.h"
#import "GEToast.h"
#import "VankeCommonModel.h"

#pragma mark -

@interface VankeNoticeBoard_iPhone ()
{
    BOOL addBordered;
}
@end

@implementation VankeNoticeBoard_iPhone

@synthesize data = _data;

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUILabel, lblContent )
DEF_OUTLET( BeeUIView, viewAtts )

- (void)load
{
}

- (void)unload
{
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    [UIApplication sharedApplication].statusBarHidden = NO;
    
    self.navigationBarShown = YES;
    self.title = @"公告";
    self.allowedSwipeToBack = YES;
    
    addBordered = NO;
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
    if (!addBordered) {
        [VankeUtil drawDashedBorderAroundView:self.viewAtts cornerRadius:5 borderWidth:1 borderColor:[UIColor grayColor]];
        addBordered = YES;
    }
}

ON_WILL_APPEAR( signal )
{
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

ON_LOAD_DATAS( signal ) {
    if (nil == self.data) {
        return;
    }
    
    $(@"lblTitle").DATA(_data.title);
    $(@"lblPublisher").DATA(_data.create_operName);
    $(@"lblPublishTime").DATA(_data.create_time);
    
    NSAttributedString * attrStr = [[NSAttributedString alloc] initWithData:[_data.content dataUsingEncoding:NSUnicodeStringEncoding] options:@{ NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType } documentAttributes:nil error:nil];
    _lblContent.attributedText = attrStr;

    [self performSelector:@selector(commitReadState)];
}

/**
 *  提交已读状态
 */
-(void) commitReadState {
    VankeBaseAPI *api = [VankeBaseAPI api];
    
    @weakify(api);
    
    User *curUser = [[VankeCommonModel sharedInstance] currentUser];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSString *curTime = [dateFormatter stringFromDate:[NSDate date]];
    
    NSString *url = [NSString stringWithFormat:@"/affiche/read/%@", _data.uuid];
    NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:
                          curTime, @"read_time",
                          curUser.uuid, @"user_uuid",
                          nil];
    [api http_post:url].BODY(dict).TIMEOUT(10);
    
    api.whenSucceed = ^{
        @normalize(api);
        [GEToast hideProgress];
        NSLog(@"response: %@", api.responseString);
    };
    api.whenFailed = ^{
        @normalize(api);
        [GEToast hideProgress];
        NSLog(@"response: %@", api.responseString);
    };
    
    [GEToast showProgress:self.view];
    [api send];
}

@end
