

#import "VankeNoticeListBoardCell_iPhone.h"
#import "VankeUtil.h"

#pragma mark -

@implementation VankeNoticeListBoardCell_iPhone

SUPPORT_RESOURCE_LOADING(YES)
SUPPORT_AUTOMATIC_LAYOUT(YES)

DEF_OUTLET( BeeUIImageView,      imgPriority )
DEF_OUTLET( BeeUILabel,          lblPriority )
DEF_OUTLET( BeeUILabel,          lblTitle )
DEF_OUTLET( BeeUILabel,          lblPublisher )
DEF_OUTLET( BeeUILabel,          lblPublishTime )

- (BOOL)dataWillChange:(id)newData
{
    return newData != self.data;
}

- (void)dataDidChanged
{
    Notice *obj = self.data;
    if (nil == obj) {
        return;
    }
    
    $(self.lblTitle).DATA(obj.title);
    [self setPriority:obj.priority];
    
    $(self.lblPublisher).DATA([NSString stringWithFormat:@"发布人: %@", obj.create_operName]);
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSDate *createTime = [dateFormatter dateFromString:obj.create_time];
    NSDateFormatter *dateFormatter2 = [[NSDateFormatter alloc] init];
    [dateFormatter2 setDateFormat:@"yyyy-MM-dd"];
    $(self.lblPublishTime).DATA([NSString stringWithFormat:@"发布时间: %@", [dateFormatter2 stringFromDate: createTime]]);
}

-(void) setPriority: (NSNumber*) priority {
    $(self.imgPriority).REMOVE_CLASS(@"low");
    $(self.imgPriority).REMOVE_CLASS(@"medium");
    $(self.imgPriority).REMOVE_CLASS(@"high");
    
    int v = [priority intValue];
    if (v == 0) {
        $(self.imgPriority).ADD_CLASS(@"low");
    } else if (v == 1) {
        $(self.imgPriority).ADD_CLASS(@"medium");
    } else if (v == 2) {
        $(self.imgPriority).ADD_CLASS(@"high");
    }
    $(self.lblPriority).DATA(priority);
}



@end


