//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementDetailListCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementDetailListCell_iPhone.h"
#import "VankeSettlementSubjectListAPI.h"
#import "VankeUtil.h"

#pragma mark -

@implementation VankeStatementDetailListCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET(BeeUIImageView, imgPhoto)
DEF_OUTLET(BeeUILabel, lblName)
DEF_OUTLET(BeeUILabel, lblAmount)
DEF_OUTLET(BeeUILabel, lblDateRange)

- (void)load
{
}

- (void)unload
{
}

- (void)dataDidChanged
{
    SubjectItem *item = (SubjectItem*) self.data;
    if (!item) {
        return;
    }
    
    if ([item.direction intValue] < 0) {
        $(self.imgPhoto).DATA(@"money_reduce.png");
    } else {
        $(self.imgPhoto).DATA(@"money_add.png");
    }
    
    $(self.lblName).DATA(item.subject);
    if ([VankeUtil isBlankString:item.remark]) {
        $(@"btnRemark").HIDE();
    } else {
        $(@"btnRemark").SHOW();
    }
    
    $(self.lblAmount).DATA([NSString stringWithFormat:@"%.2f ", [item.amount doubleValue]]);
    $(self.lblDateRange).DATA([NSString stringWithFormat:@"%@ 至 %@", item.beginDate, item.endDate]);
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

ON_SIGNAL3(VankeStatementDetailListCell_iPhone, btnRemark, signal) {
    SubjectItem *item = (SubjectItem*) self.data;
    if (!item) {
        return;
    }
    
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"备注"
                                                    message:item.remark
                                                   delegate:nil
                                          cancelButtonTitle:@"确定"
                                          otherButtonTitles:nil, nil];
    [alert show];
}

@end
