//
//	 ______    ______    ______    
//	/\  __ \  /\  ___\  /\  ___\   
//	\ \  __<  \ \  __\_ \ \  __\_ 
//	 \ \_____\ \ \_____\ \ \_____\ 
//	  \/_____/  \/_____/  \/_____/ 
//
//	Powered by BeeFramework
//
//
//  VankeStatementMonthCell_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/11/16.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeStatementMonthCell_iPhone.h"
#import "VankeSettlementListAPI.h"
#import "VankeCommonModel.h"

#pragma mark -

@implementation VankeStatementMonthCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUILabel,     lblYear )
DEF_OUTLET( BeeUILabel,     lblMonth )
DEF_OUTLET( BeeUILabel,     lblCount )
DEF_OUTLET( BeeUILabel,     lblAmount )
DEF_OUTLET( BeeUILabel,     lblTotalPrefix )

@synthesize settleDate = _settleDate;

- (void)load
{
    
}

- (void)unload
{
}

- (void)dataDidChanged
{
    StatementListResponse *resp = (StatementListResponse*) self.data;
    if (nil == resp) {
        [self setSettleDate:[NSDate date]];
        $(self.lblCount).DATA([NSString stringWithFormat:@" %d ", 0]);
        $(self.lblAmount).DATA([NSString stringWithFormat:@"%.2f ", 0.0f]);
        return;
    }
    
    [self setSettleDate:resp.settle];
    $(self.lblCount).DATA([NSString stringWithFormat:@" %d ", [resp.data.paging.recordCount intValue]]);
    
    NSNumber *amount = resp.data.amount;
    $(self.lblAmount).DATA([NSString stringWithFormat:@"%.2f ", nil == amount? 0.0f:[amount doubleValue]]);
    
    VankeCommonModel *model = [VankeCommonModel sharedInstance];
    LoginResponseData *loginInfo = [model getLoginInfo];
    if (nil != loginInfo) {
        if ([USER_POSITION_TENANT eq:loginInfo.position]) {
            $(self.lblTotalPrefix).DATA(@"应付金额");
        } else {
            $(self.lblTotalPrefix).DATA(@"应收金额");
        }
    }
}

- (void)layoutDidFinish
{
    // TODO: custom layout here
}

-(void) setSettleDate: (NSDate*) date {
    _settleDate = date;
    
    if (nil == date) {
        $(self.lblYear).DATA(@"");
        $(self.lblMonth).DATA(@"");
    } else {
        $(self.lblYear).DATA([NSString stringWithFormat:@"%lu", date.year]);
        $(self.lblMonth).DATA([NSString stringWithFormat:@"%lu", date.month]);
    }
}

@end

