//
//  ChooseParentViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/2.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseParentViewController.h"
#define TopMargin 50
#define TableHeight 50

@interface ChooseParentViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>
@end

@implementation ChooseParentViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
    [self createRefresh];
}

- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    [self.selectTextFiled addTarget:self action:@selector(boxValueChanged:) forControlEvents:UIControlEventEditingChanged];
    self.selectTextFiled.font = GXF_FIFTEENTEN_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    self.selectTextFiled.leftView = leftView;
    self.selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deleteTextFieldStr) forControlEvents:UIControlEventTouchUpInside];
    self.selectTextFiled.rightView = rightView;
    self.selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (self.isRefresh) {
            return ;
        }
        self.isRefresh = YES;
        [self getBaseDataFromServer];
    }];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        return;
    }
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        if (![self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
            [self.indexArr addObject:indexPath];
        }else{
            cell.Commitbtn.hidden = YES;
            [self.indexArr removeObject:indexPath];
        }
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:self.currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        self.currentIndexPath = indexPath;
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}
- (void)keyboardHidden{
    [self.selectTextFiled resignFirstResponder];
}

#pragma mark - 结束刷新
- (void)endRefreshing{
    self.isRefresh = NO;
    [self.tableView.header endRefreshing];
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)deleteTextFieldStr{
    self.selectTextFiled.text = @"";
    [self boxValueChanged:nil];
}
#pragma mark - 按钮事件
- (void)boxValueChanged:(NSNotification *)fication{
//    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
//    [self fetchDataList:tilkeStr];
}
- (void)tableViewRefresh{
    self.currentIndexPath = nil;
    if (self.indexArr.count > 0) {
        [self.indexArr removeAllObjects];
    }
    [self.tableView reloadData];
}
- (void)fetchDataList:(NSString *)titleStr tableStr:(NSString *)tableStr{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = @"";
        if (titleStr.length > 0) {
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE NAME LIKE '%%%@%%' ORDER BY %@", tableStr,titleStr, @"uuid"];
        }else{
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", tableStr, @"uuid"];
        }
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (fetchedObjects.count == 0 && titleStr.length == 0) {
            [GXF_NSUSERFEFTAULTS setObject:[NSDate date] forKey:self.tableView.header.lastUpdatedTimeKey];
            [GXF_NSUSERFEFTAULTS synchronize];
            [self getBaseDataFromServer];
        }else{
            [strongSelf.dataArr removeAllObjects];
            [strongSelf.dataArr addObject:self.tableView.header.lastUpdatedTime];
            [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
            [self tableViewRefresh];
        }
        
    };
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:NSClassFromString(tableStr)
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}
#pragma mark -成功
- (void)sureClick{
    if (self.isMoreChose) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            [arr addObject:self.dataArr[index.row]];
        }
        self.choseBaseInfo(arr);
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
            if (self.currentIndexPath) {
                [arr addObject:self.dataArr[self.currentIndexPath.row]];
                self.choseBaseInfo(arr);
            }
        }
    }
    [self PopViewControllerAnimated:YES];
}

#pragma mark -childFunction
-(void)getBaseDataFromServer
{
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
