//
//  JTPopupView.m
//  JobTalk
//
//  Created by Xummer on 15/1/27.
//  Copyright (c) 2015年 BST. All rights reserved.
//

#import "JTPopupView.h"
#import "JTPopOverWindow.h"

@interface JTPopupView ()

@property (strong, nonatomic) UIControl *bgContainer;
@property (strong, nonatomic) UIView *blurBGView;

@end

@implementation JTPopupView

#pragma mark - Life Cycle
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    [self initSubviews];
    
    self.m_bEnableTapToDismiss = YES;
    
    return self;
}

- (void)initSubviews {
    self.backgroundColor = [UIColor whiteColor];
    
    self.blurBGView = [[UIView alloc] initWithFrame:self.bounds];
    _blurBGView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    
    UIView *maskView = [[UIView alloc] initWithFrame:_blurBGView.bounds];
    maskView.backgroundColor = [UIColor colorWithR:31.0f g:38.0f b:45.0f a:.85];
    maskView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    [_blurBGView addSubview:maskView];
}

#pragma mark - Public Method
- (UIView *)backgroundContainer {
    return _bgContainer;
}

- (UIView *)blurView {
    return _blurBGView;
}

- (void)showInView:(UIView *)view {
    JTPopOverWindow *backgroundWindow = [JTPopOverWindow sharedInstance];
    backgroundWindow.statusBarStyle = UIStatusBarStyleLightContent;
    
    if (!_bgContainer) {
        self.bgContainer = [[UIControl alloc] initWithFrame:backgroundWindow.bounds];
        [_bgContainer addTarget:self
                         action:@selector(backgroundTappedAction:)
               forControlEvents:UIControlEventTouchUpInside];
        self.bgContainer.backgroundColor = [UIColor colorWithW:0 a:.8f];
    }
    
    if (_m_bShowShowInCenter) {
        self.center = CGPointMake(_bgContainer.width * .5f, _bgContainer.height * .5f);
    }
    
    [_bgContainer addSubview:self];
    
    
//    _blurBGView.underlyingView = view;
    [backgroundWindow addToMainWindow:_bgContainer];
    
    [UIView animateWithDuration:0.4
                          delay:0.0
                        options:UIViewAnimationOptionCurveEaseOut
                     animations:^{
                         [JTPopOverWindow sharedInstance].alpha = 1.0f;
                     }
                     completion:^(BOOL finished) {
                         
                     }];
    
}

- (void)dismissPopup {
    [UIView animateWithDuration:0.4
                          delay:0.0
                        options:UIViewAnimationOptionCurveEaseIn
                     animations:^{
                         [[JTPopOverWindow sharedInstance] reduceAlphaIfEmpty];
                     }
                     completion:^(BOOL finished) {
                         [[JTPopOverWindow sharedInstance] removeView:_bgContainer];
                     }];
}

#pragma mark - Actions
- (void)backgroundTappedAction:(__unused id)sender {
    
    if (_m_bEnableTapToDismiss) {
        [self dismissPopup];
    }
}

@end
