//
//  ProductViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ProductBillViewController.h"
#import "FooterCell.h"
#import "HeaderCell.h"
#import "ProductBillCell.h"
#import "PurchaseBillProduct.h"
#define TableHeight 44
#define ShowHeight  110

@interface ProductBillViewController ()<UITableViewDataSource,UITableViewDelegate,FooterCellDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
@end

@implementation ProductBillViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [super viewDidLoad];
    [self initData];
    [self createView];
}
- (void)initData{
    _selectRowArr = [[NSMutableArray alloc]init];
    if (!self.productArr) {
        self.productArr = [NSMutableArray array];
    }
    PurchaseBillProduct *billProduct = [PurchaseBillProduct new];

    billProduct.product_name = @"dd";
    billProduct.product_uuid  = @"402880e64e287fe2014e28895b8a0032";
    billProduct.product_code = @"农夫山泉";
    billProduct.qpc = [NSNumber numberWithFloat:22];
    billProduct.unit = @"筐";
    billProduct.qty = [NSNumber numberWithFloat:23];
    billProduct.price = [NSNumber numberWithFloat:333];
    billProduct.baseQty = [NSNumber numberWithFloat:333];
    billProduct.basePrice = [NSNumber numberWithFloat:33];
    billProduct.total = [NSNumber numberWithFloat:80];
    billProduct.remark = @"hshshshsh";
    billProduct.qpcStr = @"fdsfdsfdsa";
    [self.productArr addObject:billProduct];
    if (self.productArr.count > 0) {
         [[NSNotificationCenter defaultCenter] postNotificationName:SetProductTotalPrice object:nil];
    }
}

- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr];
    [self.view addSubview:headCell];
    self.tableView.tableHeaderView = headCell;
    
    if (!self.isHiddenEdit) {
        FooterCell *footCell = [[FooterCell alloc]initWithFrame:CGRectMake(0, 0, _tableFrame.size.width, 50) withTitle:@"+点击添加商品明细" isTwo:self.twoTitle];
        [self.view addSubview:footCell];
        footCell.delegate = self;
        self.tableView.tableFooterView = footCell;
    }
}
#pragma mark - footerDelegate
- (void)addClick{
     [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil];
}
- (void)choosePurchase{
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_ChoseTransportPurchase object:nil];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.productArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"ProductBillCell";
    ProductBillCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[ProductBillCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = ShowHeight + TableHeight -1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = ShowHeight;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = [UIColor whiteColor];
    }
    cell.editBtn.tag = indexPath.row;
    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
    
    if (self.productArr.count > 0) {
        PurchaseBillProduct *billP = self.productArr[indexPath.row];
        [cell setBillProduct:billP row:indexPath.row];
    }
    
    
    return cell;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ProductBillCell *cell = (ProductBillCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];

        Linefrmame.origin.y = ShowHeight + TableHeight - 1;
        showfrmame.size.height = ShowHeight;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return ShowHeight + TableHeight;
    }
    return TableHeight;
}

- (void)editClick:(UIButton *)btn{
    UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"" message:@"哈哈" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
    [alert show];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
