//
//  TransportPurchaseCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportPurchaseCell.h"
#import "TransportPurductCell.h"
#import "HeaderCell.h"
@implementation TransportPurchaseCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.contentView.backgroundColor = XXFBgColor;
    
    UIView *bgView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 200)];
    bgView.backgroundColor = [UIColor whiteColor];
    [self.contentView addSubview:bgView];
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,0, ScreenSize.width, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;

    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, 0, ScreenSize.width, 44))];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.text = @"苹果桃子";
    self.titleLabel.font = GXF_SEVENTEENTH_SIZE;
    
    self.secondLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,44-1, ScreenSize.width, 1))];;
    self.secondLabel.backgroundColor = GXF_LINE_COLOR;
    
    self.threeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,200-1, ScreenSize.width, 1))];;
    self.threeLabel.backgroundColor = GXF_LINE_COLOR;
    
    [bgView addSubview:self.titleLabel];
    [bgView addSubview:self.lineLabel];
    [bgView addSubview:self.secondLabel];
    [bgView addSubview:self.threeLabel];


}
- (void)setBill:(PurchaseBill *)bill{
    self.titleLabel.text = [NSString stringWithFormat:@"[采购单:%@]",bill.billNumber];
    self.secondArr = [NSMutableArray array];
    self.selectArr = [NSMutableArray array];
    [self.secondArr addObjectsFromArray:bill.products];
//    for (NSDictionary *billDict in bill.products) {
//        PurchaseBillProduct *billProcuct = [PurchaseBillProduct new];
//        [billProcuct setValuesForKeysWithDictionary:billDict];
//        [self.secondArr addObject:billProcuct];
//    }

    self.secondTable = [[UITableView alloc]initWithFrame:(CGRectMake(0, 44,ScreenSize.width, 200-45)) style:(UITableViewStylePlain)];

    self.secondTable.delegate = self;
    self.secondTable.dataSource = self;
    self.secondTable.bounces = NO;
    self.secondTable.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.contentView addSubview:self.secondTable];
    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr];
    self.secondTable.tableHeaderView = headCell;
    //重要
    [self.secondTable reloadData];

}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.secondArr.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellID = @"TransportPurductCell";
    TransportPurductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[TransportPurductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID withImageName:@"selected"];
        cell.editBtn.hidden = YES;
        cell.rightImageName = @"edit";
    }
    TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
    [cell setPdtDetail:billProduct row:indexPath.row];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
      TransportPurductCell *cell = (TransportPurductCell *)[tableView cellForRowAtIndexPath:indexPath];
      TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
        if (![self isHaveIndexPath:indexPath]) {
            cell.editBtn.hidden = NO;
            [self.selectArr addObject:indexPath];
            [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_getSelectPurchaseProduct object:nil userInfo:@{@"selectArr":billProduct,@"state":@"add"}];
        }else{
            [self.selectArr removeObject:indexPath];
            cell.editBtn.hidden = YES;
            [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_getSelectPurchaseProduct object:nil userInfo:@{@"selectArr":billProduct,@"state":@"remove"}];
        }
    
    ;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.selectArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
