//
//  NotuceRecordCell.m
//  XFFruit
//
//  Created by mac on 15/9/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NotuceRecordCell.h"
#define LeftMargin 10
@implementation NotuceRecordCell

- (void)awakeFromNib {
    // Initialization code
}
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.contentView.backgroundColor = XXFBgColor;
    
    UIView *bgView = [[UIView alloc]initWithFrame:CGRectMake(20, 5, ScreenSize.width - 40, 130 -10)];
    bgView.backgroundColor = [UIColor whiteColor];
    bgView.layer.cornerRadius = 5;
    bgView.layer.masksToBounds = YES;
    [self.contentView addSubview:bgView];
    
    self.createdLable = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 0, bgView.width - 100, 30)];//业务时间
    self.createdLable.font = GXF_FIFTEENTEN_SIZE;
    self.createdLable.textColor = GXF_CELL_COLOR;
    self.createdLable.text = @"2015-04-05 09:05:05";
    
    self.creatorLable = [[UILabel alloc]initWithFrame:CGRectMake(self.createdLable.right, 0, bgView.width - self.createdLable.width - LeftMargin * 2, 30)];//业务人
    self.creatorLable.font = GXF_FIFTEENTEN_SIZE;
    self.creatorLable.textAlignment = NSTextAlignmentRight;
    self.creatorLable.textColor = GXF_CELL_COLOR;
    
    self.traceIdLable = [[UILabel alloc]initWithFrame:CGRectMake(self.createdLable.x, self.createdLable.bottom, bgView.width - LeftMargin*2, 20)];//采购通知单uuid
    self.traceIdLable.font = GXF_FIFTEENTEN_SIZE;
    self.traceIdLable.textColor = GXF_CELL_COLOR;
    
    self.typeLable = [[UILabel alloc]initWithFrame:CGRectMake(self.createdLable.x, self.traceIdLable.bottom, bgView.width- LeftMargin*2, 20)];//业务类型
    self.typeLable.font = GXF_FIFTEENTEN_SIZE;
    self.typeLable.textColor = GXF_CELL_COLOR;
    
    self.remarkLable = [[UILabel alloc]initWithFrame:CGRectMake(self.createdLable.x, self.typeLable.bottom, bgView.width-LeftMargin*2, 20)];//日志描述信息
    self.remarkLable.font = GXF_FIFTEENTEN_SIZE;
    self.remarkLable.textColor = GXF_CELL_COLOR;
    
    [bgView addSubview:self.createdLable];
    [bgView addSubview:self.creatorLable];
    [bgView addSubview:self.traceIdLable];
    [bgView addSubview:self.remarkLable];
    [bgView addSubview:self.typeLable];
    [bgView addSubview:self.uuidLable];
}

- (void)setNoticeRecode:(NoticeRecord *)noticeRecode withNumber:(NSString *)number{
    self.creatorLable.text = [NSString stringWithFormat:@"%@",noticeRecode.creator];
    self.createdLable.text = [NSString stringWithFormat:@"%@",noticeRecode.created];
    self.traceIdLable.text = [NSString stringWithFormat:@"单号：%@",number];
    
      NSMutableAttributedString *attributeStr1 = [IBTCommon setTextViewFontOfString:@"类型：" paragraphStyle:0 fontSize:15 color:GXF_CELL_COLOR];
    

    NSString *str = @"";
    if ([noticeRecode.type isEqualToString:@"noticeAccepted"]) {
        str = @"接受任务";
    }else if ([noticeRecode.type isEqualToString:@"billCreated"]){
        str = @"新建采购单";
    }
    [attributeStr1 appendAttributedString:[IBTCommon setTextViewFontOfString:str paragraphStyle:0 fontSize:15 color:[UIColor redColor]]];
    self.typeLable.attributedText = attributeStr1;
    self.remarkLable.text = [NSString stringWithFormat:@"备注：%@",noticeRecode.remark];
    self.remarkLable.numberOfLines = 0;
    
    CGFloat height =  [self.remarkLable calculateHeight];
    if (height > 20) {
        self.remarkLable.height = height;
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
