//
//  SurveyDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyDetailViewController.h"
#import "ResultDetailViewController.h"
#import "SurveyUser.h"
#import "UIImageView+WebCache.h"
#define BottomHeight 50
#define LeftMargin 20
#define LeftWidth 100
#define LeftHeight 20
#define TopMargin 15
#define ContentMargin 10

typedef enum : NSUInteger {
    DetailTag = 6000,
    EndTag,
} BtnTag;

@interface SurveyDetailViewController ()<UIAlertViewDelegate>
{
    UIScrollView *_scrollView;
    UIView *_surveyView;
    UIView *_bottomView;
    UIImageView *_chartImageView;
}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *titleLabel;
@property (nonatomic,strong)UILabel *productLabel;
@property (nonatomic,strong)UILabel *beginDateLabel;
@property (nonatomic,strong)UILabel *endDateLabel;
@property (nonatomic,strong)UILabel *userLabel;
@property (nonatomic,strong)UILabel *noteLabel;
@property (nonatomic,strong)UILabel *lefeNoteLabel;

@end

@implementation SurveyDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
     self.title = @"行情调研详情";
    [self bulifLayout];
    [self getDataFromServer];
}

- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                Survey *survey = [[Survey alloc]init];
                [survey setValuesForKeysWithDictionary:dictData];
                self.survey = survey;
                [strongSelf fetchtSurveyDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [strongSelf fetchtSurveyDetail];
        }
        [self createResultChart];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getResultWithSurveyUuid:self.surveyUuid success:succ failure:fail];
}

- (void)createResultChart {
    void(^succ)(id) = ^(id data) {
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSString *dataStr = data[@"data"];
               NSString *urlStr = [NSString stringWithFormat:@"%@/DisplayChart?filename=%@",Server_Url,dataStr];
                [_chartImageView sd_setImageWithURL:[NSURL URLWithString:urlStr]];
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [[ICRHTTPController sharedController] resultChartWithResultUuid:self.surveyUuid width:[NSNumber numberWithFloat:CGRectGetWidth(_chartImageView.frame)] height:[NSNumber numberWithFloat:CGRectGetHeight(_chartImageView.frame)] success:succ failure:fail];
}



- (void)fetchtSurveyDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.survey.billNumber];
    if ([self.survey.state isEqualToString:SURVEY_STATE_INITIAL]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"未提交";
    }else if ([self.survey.state isEqualToString:SURVEY_STATE_SUBMITTED]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已提交";
    }else if ([self.survey.state isEqualToString:SURVEY_STATE_INSURVEY]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"调研中";
    }else if ([self.survey.state isEqualToString:SURVEY_STATE_FINISHED]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"已完成";
    }
    NSString *user = @"";
    for (NSDictionary *userDict  in self.survey.users) {
        SurveyUser *surveyUser = [[SurveyUser alloc]init];
        [surveyUser setValuesForKeysWithDictionary:userDict];
        if (user.length == 0) {
            user = [user stringByAppendingFormat:@"%@",surveyUser.userName];
        }else{
            user = [user stringByAppendingFormat:@"、%@",surveyUser.userName];
        }
    }
    self.titleLabel.text = [IBTCommon checkString:self.survey.title];
    self.productLabel.text = [IBTCommon checkString:self.survey.productName];
    self.beginDateLabel.text = [IBTCommon checkString:self.survey.beginDate];
    self.endDateLabel.text = [IBTCommon checkString:self.survey.endDate];
    self.userLabel.text = [IBTCommon checkString:user];
    self.noteLabel.text = [NSString stringWithFormat:@"%@",self.survey.remark?self.survey.remark : @"无"];
    [self setNoteHeight];
}



#pragma mark - 视图初始化
- (void)bulifLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];
    
    
    UIButton *endBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin*2, 40) target:self sel:@selector(btnClick:) tag:EndTag image:nil title:@"结束" titleColor:[UIColor whiteColor] isCorner:YES corner:8 bgColor:GXF_COMMIT_COLOR];
    [self.view addSubview:endBtn];
    
    _surveyView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight * 9+ ContentMargin * 10)];
    _surveyView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_surveyView];
    
    UILabel *tagLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin/2, ContentMargin, LeftWidth*2, LeftHeight)];
    tagLabel.text = @"【调研内容】";
    tagLabel.font =  GXF_SEVENTEENTH_SIZE;
    tagLabel.textColor = HexColor(@"7ebf74");
    [_surveyView addSubview:tagLabel];
    
    NSArray *leftArr = @[@"单号:",@"状态:",@"标题:",@"商品:",@"开始日期:",@"截止日期:",@"调研人员:",@"备注:"];
    for (NSInteger i = 0 ; i < leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, CGRectGetMaxY(tagLabel.frame) + ContentMargin+ (LeftHeight + ContentMargin) *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = leftArr[i];
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_surveyView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), CGRectGetMaxY(tagLabel.frame) + ContentMargin+ (LeftHeight + ContentMargin) *i, _surveyView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        if (i == 0) {
            self.billNumberLabel = rightLabel;
        }else if (i == 1) {
            self.stateLabel = rightLabel;
        }else if(i == 2){
            self.titleLabel = rightLabel;
        }else if(i == 3){
            self.productLabel = rightLabel;
        }else if(i == 4){
            self.beginDateLabel = rightLabel;
        }else if(i == 5){
            self.endDateLabel = rightLabel;
        }else if(i == 6){
            rightLabel.numberOfLines = 0;
            self.userLabel = rightLabel;
        }else if(i == 7){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
            self.lefeNoteLabel = leftLabel;
        }
        [_surveyView addSubview:rightLabel];
    }

    
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_surveyView.frame) + TopMargin, ScreenSize.width, 300)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    
    UILabel *resultLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin/2, 10, LeftWidth*2, LeftHeight)];
    resultLabel.text = @"【行情反馈】";
    resultLabel.font =  GXF_SEVENTEENTH_SIZE;
    resultLabel.textColor = HexColor(@"7ebf74");
    [_bottomView addSubview:resultLabel];
    
    _chartImageView = [[UIImageView alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(resultLabel.frame) + 10, CGRectGetWidth(_bottomView.frame) - 20, CGRectGetHeight(_bottomView.frame) - LeftHeight - 20)];
    [_bottomView addSubview:_chartImageView];
    
    UIButton *btn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetWidth(_bottomView.frame) - 100, 10, 100, LeftHeight) target:self sel:@selector(btnClick:) tag:DetailTag image:nil title:@">>查看详情" titleColor:HexColor(@"7ebf74") isCorner:NO corner:0 bgColor:nil];
    [_bottomView addSubview:btn];
    
    
    if ([self.survey.state isEqualToString:@"finished"]) {
        endBtn.hidden = YES;
        CGRect scrollViewFrame = _scrollView.frame;
        scrollViewFrame.size.height = ScreenSize.height - 64;
        _scrollView.frame = scrollViewFrame;
    }

    
    
}
- (void)btnClick:(UIButton *)btn{
    if (btn.tag == DetailTag) {
        ResultDetailViewController *rvc = [ResultDetailViewController new];
        rvc.surveyUuid = self.surveyUuid;
        [self PushViewController:rvc animated:YES];
    }else if (btn.tag == EndTag){
        UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认结束" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
        alertView.delegate = self;
        [alertView show];
    }
}

#pragma mark - 结束行情调研
- (void)finishSurveyRequest{
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                [self backSurvey];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"返回异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] surveyFinishWithUuid:self.surveyUuid version:self.survey.version success:succ failure:fail];
}
//返回列表
- (void)backSurvey{
    [ICRUserUtil sharedInstance].needFresh = YES;
    [self PopViewControllerAnimated:YES];
}

- (void)setNoteHeight
{
    CGFloat personHeight = [self.userLabel calculateHeight];
    
    CGRect personFrame = self.userLabel.frame;
    personFrame.size.height = personHeight;
    self.userLabel.frame = personFrame;
    
    CGFloat noteHeight =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = noteHeight;
    noteFrame.origin.y = CGRectGetMaxY(self.userLabel.frame)+ ContentMargin;
    self.noteLabel.frame = noteFrame;
    
    CGRect leftNoteFrame = self.lefeNoteLabel.frame;
    leftNoteFrame.origin.y = CGRectGetMaxY(self.userLabel.frame)+ ContentMargin;
    self.lefeNoteLabel.frame = leftNoteFrame;
    
    CGFloat totalHeight = noteHeight + (LeftHeight * 7+ ContentMargin*10) + personHeight;
    CGRect surveyFrame = _surveyView.frame;
    surveyFrame.size.height = totalHeight;
    _surveyView.frame = surveyFrame;
    
    
    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_surveyView.frame) + TopMargin;
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (buttonIndex == 1) {
        [self finishSurveyRequest];//结束
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
@end
