//
//  ICRPatrolPlanCellContentView.m
//  XFFruit
//
//  Created by Lili Wang on 15/5/11.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRPatrolPlanCellContentView.h"
#import "ICRPatrolPlan.h"

#define PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR        [UIColor blackColor]
#define PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR      [UIColor grayColor]

#define PATROL_PLAN_CONTENT_LABEL_VERTICAL_MARGIN    (10.0f)
#define PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN     (15.0f)
#define PATROL_PLAN_CONTENT_LABEL_INNER_GAP          (5.0f)
#define PATROL_PLAN_CONTENT_LABEL_HEIGHT             (16)

@interface ICRPatrolPlanCellContentView ()

@property (strong, nonatomic) UILabel *m_titleLabel;
@property (strong, nonatomic) UILabel *m_typeLabel;
@property (strong, nonatomic) UILabel *m_typeValueLabel;
@property (strong, nonatomic) UILabel *m_startTimeLabel;
@property (strong, nonatomic) UILabel *m_startTimeValueLabel;
@property (strong, nonatomic) UILabel *m_endTimeLabel;
@property (strong, nonatomic) UILabel *m_endTimeValueLabel;
@property (strong, nonatomic) UILabel *m_totalStoresNumLabel;
@property (strong, nonatomic) UILabel *m_surplusStoresNumLabel;

@end

@implementation ICRPatrolPlanCellContentView

#pragma mark - Life Cycle

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // code
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    
    CGFloat MaxW = self.width - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN;
    
    CGSize size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_titleLabel widthLimitedSizeThatFits:size];
    _m_titleLabel.frame = ((CGRect){
        .origin.x = PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN,
        .origin.y = PATROL_PLAN_CONTENT_LABEL_VERTICAL_MARGIN,
        .size = size
    });
    
    size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_typeLabel widthLimitedSizeThatFits:size];
    _m_typeLabel.frame = ((CGRect){
        .origin.x = _m_titleLabel.left,
        .origin.y = _m_titleLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - _m_typeLabel.right, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_typeValueLabel widthLimitedSizeThatFits:size];
    _m_typeValueLabel.frame = ((CGRect){
        .origin.x = _m_typeLabel.right,
        .origin.y = _m_typeLabel.top,
        .size = size
    });
    
    size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_startTimeLabel widthLimitedSizeThatFits:size];
    _m_startTimeLabel.frame = ((CGRect){
        .origin.x = _m_typeLabel.left,
        .origin.y = _m_typeValueLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - _m_startTimeLabel.right, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_startTimeValueLabel widthLimitedSizeThatFits:size];
    _m_startTimeValueLabel.frame = ((CGRect){
        .origin.x = _m_startTimeLabel.right,
        .origin.y = _m_startTimeLabel.top,
        .size = size
    });
    
    size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_endTimeLabel widthLimitedSizeThatFits:size];
    _m_endTimeLabel.frame = ((CGRect){
        .origin.x = _m_startTimeLabel.left,
        .origin.y = _m_startTimeLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - _m_endTimeLabel.right, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_endTimeValueLabel widthLimitedSizeThatFits:size];
    _m_endTimeValueLabel.frame = ((CGRect){
        .origin.x = _m_endTimeLabel.right,
        .origin.y = _m_endTimeLabel.top,
        .size = size
    });
    
    if (_m_bHiddenNumLabel) {
        
        size = CGSizeMake((MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN ) * 0.5, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
        size = [_m_totalStoresNumLabel widthLimitedSizeThatFits:size];
        _m_totalStoresNumLabel.frame = ((CGRect){
            .origin.x = _m_endTimeLabel.left,
            .origin.y = _m_endTimeLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
            .size = size
        });
        
        size = CGSizeMake((MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN ) * 0.5, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
        size = [_m_surplusStoresNumLabel widthLimitedSizeThatFits:size];
        _m_surplusStoresNumLabel.frame = ((CGRect){
            .origin.x = self.width * 0.5,
            .origin.y = _m_totalStoresNumLabel.top,
            .size = size
        });
    }
    
    
    //self.height = _m_endTimeValueLabel.bottom + PATROL_PLAN_CONTENT_LABEL_VERTICAL_MARGIN;
}

#pragma mark - Private Method

- (void)_init {
    
    self.m_titleLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    [self addSubview:_m_titleLabel];
    
    self.m_typeLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    _m_typeLabel.text = [IBTCommon localizableString:@"Type:"];
    [self addSubview:_m_typeLabel];
    
    self.m_typeValueLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_typeValueLabel];
    
    self.m_startTimeLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    _m_startTimeLabel.text = [IBTCommon localizableString:@"Start Time:"];
    [self addSubview:_m_startTimeLabel];
    
    self.m_startTimeValueLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_startTimeValueLabel];
    
    self.m_endTimeLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    _m_endTimeLabel.text = [IBTCommon localizableString:@"End Time:"];
    [self addSubview:_m_endTimeLabel];
    
    self.m_endTimeValueLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_endTimeValueLabel];
    
    self.m_totalStoresNumLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_totalStoresNumLabel];
    
    self.m_surplusStoresNumLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_surplusStoresNumLabel];
}

#pragma mark - Class Method

+ (IBTUILabel *)customLabelWithTextColor:(UIColor *)textColor {
    
    IBTUILabel *label = [[IBTUILabel alloc] init];
    label.textAlignment = NSTextAlignmentLeft;
    label.textColor = textColor;
    label.font = [UIFont systemFontOfSize:15];
    
    return label;
}

@end

@implementation ICRPatrolPlanCellContentView (Configure)

- (void)updateValueLabelWithData:(id)data {
    
    if ([data isKindOfClass:[ICRPatrolPlan class]]) {
        
        ICRPatrolPlan *patrol = data;
        
        _m_titleLabel.text = patrol.name;
        _m_typeValueLabel.text = patrol.category;
        _m_startTimeValueLabel.text = patrol.beginDate ;
        _m_endTimeValueLabel.text = patrol.endDate  ;
        
        
        if (_m_bHiddenNumLabel) {
            
            NSUInteger uiTotal = patrol.inspectors.count;
            NSUInteger uiSuplus = 0;
            
            if( patrol.inspectors.count > 0 ) {
                for (NSDictionary *inspector in patrol.inspectors) {
                    if ([inspector[ @"state" ] integerValue] == 0) {
                        uiSuplus ++;
                    }
                }
            }
            
            NSString *nsHLText = [NSString stringWithFormat:@"%@",@( uiSuplus )];
        
            NSString *nsText = [NSString stringWithFormat:@"剩余门店:%@",nsHLText];
        
            NSDictionary *attrs = @{
                                    NSForegroundColorAttributeName : _m_surplusStoresNumLabel.textColor,
                                    NSFontAttributeName : _m_surplusStoresNumLabel.font
                                    };
            
            NSMutableAttributedString *attributedText =
            [[NSMutableAttributedString alloc] initWithString:nsText
                                                   attributes:attrs];
        
            NSRange highlightTextRange = [nsText rangeOfString:nsHLText];// * Notice that usage of rangeOfString in this case may cause some bugs - I use it here only for demonstration
            [attributedText setAttributes:@{ NSForegroundColorAttributeName : [UIColor redColor] }
                                    range:highlightTextRange];

            
            _m_totalStoresNumLabel.text = [NSString stringWithFormat:@"总门店数:%@",@( uiTotal )];
            _m_surplusStoresNumLabel.attributedText = attributedText;
        
        }
        
    }
    
    [self setNeedsLayout];

}

@end