//
//  IBTUIViewController.m
//  IBTImagePicker
//
//  Created by Xummer on 1/17/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTUIViewController.h"

@interface IBTUIViewController ()

@end

@implementation IBTUIViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = HexColor(@"f8f8f8");

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    if (!self.navigationController) {
        return;
    }
    
    NSInteger viewCtrlsCount = [self.navigationController.viewControllers count];
    if (!_bNotAutoAddCancelButton &&
        viewCtrlsCount == 1 &&
        !self.navigationItem.leftBarButtonItems &&
        [self isPresentedIn])
    {
        if (!_cancelButtonName) {
            self.cancelButtonName = [IBTCommon localizableString:@"Cancel"];
        }
        [self addLeftBarBtnItemWithName:_cancelButtonName action:@selector(disMissSelf)];
    }
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self addKeyboardNotification];
}

- (void)viewWillDisappear:(BOOL)animated {
    [self removeKeyboardNotification];
    [super viewWillDisappear:animated];
    [self.view endEditing:YES];
    self.navigationItem.backBarButtonItem=[self setBackBarButtonItem];
}

//设置导航条的返回按钮，在视图控制器即将消失的时候设置
- (UIBarButtonItem *)setBackBarButtonItem{
    UIBarButtonItem *backButtonItem = [[UIBarButtonItem alloc] init];
    backButtonItem.title = @"";
    return backButtonItem;
}
//收键盘操作
- (void)keyboardHidden{
}

//当点击屏幕空白处的时候，收键盘
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self keyboardHidden];
}

//当点击键盘的return键的时候，收键盘
- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self keyboardHidden];
    return YES;
}


#pragma mark - Public Method
- (void)safeSetEdgesForExtendedLayout:(UIRectEdge)extendedLayout {
    if ([self respondsToSelector:@selector(setEdgesForExtendedLayout:)]) {
        self.edgesForExtendedLayout = extendedLayout;
    }
}

- (BOOL)isPresentedIn {
    return self.presentingViewController.presentedViewController == self
    || self.navigationController.presentingViewController.presentedViewController == self.navigationController
    || [self.tabBarController.presentingViewController isKindOfClass:[UITabBarController class]];
}

- (BOOL)isPushedIn {
    if ([self.navigationController.viewControllers count] > 1) {
        return self != [self.navigationController.viewControllers firstObject];
    }
    else {
        return NO;
    }
}

- (void)disMissSelf {
    [self.presentingViewController dismissViewControllerAnimated:YES completion:NULL];
}

#pragma mark - Route

// Below iOS6 use this method
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return UIInterfaceOrientationIsPortrait(interfaceOrientation);
}

// Above iOS6 use these two methods
- (BOOL)shouldAutorotate {
    return YES;
}

- (NSUInteger)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

#pragma mark - iOS7 Status bar

- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleLightContent;
}

- (BOOL)prefersStatusBarHidden {
    return NO;
}

- (BOOL)automaticallyAdjustsScrollViewInsets {
    return NO;
}

- (UIStatusBarAnimation)preferredStatusBarUpdateAnimation {
    return UIStatusBarAnimationNone;
}

- (void)updateStatueBarAppearance {
    if ([self respondsToSelector:@selector(setNeedsStatusBarAppearanceUpdate)]) {
        [self setNeedsStatusBarAppearanceUpdate];
    }
}

#pragma mark - Keyboard Notification

- (void)addKeyboardNotification {
    NSNotificationCenter *notiCenter = [NSNotificationCenter defaultCenter];
    [notiCenter addObserver:self
                   selector:@selector(keyboardWillShow:)
                       name:UIKeyboardWillShowNotification
                     object:nil];
    [notiCenter addObserver:self
                   selector:@selector(keyboardWillHide:)
                       name:UIKeyboardWillHideNotification
                     object:nil];
}

- (void)removeKeyboardNotification {
    NSNotificationCenter *notiCenter = [NSNotificationCenter defaultCenter];
    [notiCenter removeObserver:self
                          name:UIKeyboardWillShowNotification
                        object:nil];
    [notiCenter removeObserver:self
                          name:UIKeyboardWillHideNotification
                        object:nil];
}

- (void)keyboardWillShow:(NSNotification *)note {
    
}

- (void)keyboardWillHide:(NSNotification *)note {
    
}

@end
