//
//  GXFFunctionsViewController.m
//  XFFruit
//
//  Created by freecui on 15/8/27.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFFunctionsViewController.h"
#import "GXFDisplayFunction.h"
#import "GXFFunction.h"
@interface GXFFunctionsViewController ()<UITableViewDataSource,UITableViewDelegate>

//@property (nonatomic, strong) NSArray *
@property (nonatomic, strong) UITableView *f_tableView;
@property (nonatomic, strong) NSArray *firstSectionArr;
@property (nonatomic, strong) NSArray *secondSectionArr;

@end

@implementation GXFFunctionsViewController
static NSString *cellID = @"cell";

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initData];
    [self setupSubViews];
}
- (void)initData {
    NSDictionary *dictOne = @{@"Id":@(1),@"functionName":@"新建行情反馈",@"imgName":@"RefreshBtn",@"isSelected":@(0)};
        NSDictionary *dictTwo = @{@"Id":@(2),@"functionName":@"查询行情反馈",@"imgName":@"RefreshBtn",@"isSelected":@(1)};
    GXFDisplayFunction *dFuntionOne = [[GXFDisplayFunction alloc]initWithDictionary:dictOne];
    GXFDisplayFunction *dFuntionTwo = [[GXFDisplayFunction alloc]initWithDictionary:dictTwo];
    self.firstSectionArr = @[dFuntionOne,dFuntionTwo];
    self.secondSectionArr = @[dFuntionOne,dFuntionTwo];
    
    //self.firstSection =
}
- (void)setupSubViews {
    [self setupRightBarBtn];
    [self setupTableView];
}
- (void)setupRightBarBtn {
    UIBarButtonItem *rightBarBtn =  [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(selectedFunctions)];
    self.navigationItem.rightBarButtonItem = rightBarBtn;
}
- (void)setupTableView {
    self.f_tableView = [[UITableView alloc]initWithFrame:self.view.frame style:UITableViewStyleGrouped];
    self.f_tableView.dataSource = self;
    self.f_tableView.delegate = self;
    //[self.f_tableView dequeueReusableCellWithIdentifier ]
    [self.view addSubview:_f_tableView];
}



#pragma BarButton Action
- (void)selectedFunctions {
    
    [self PopViewControllerAnimated:YES];
}


#pragma UITablewViewDataSource 
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section == 0) {
        return _firstSectionArr.count;
    } else {
        return _secondSectionArr.count;
    }
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (!cell) {
        cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
    }
    switch (indexPath.section) {
        case 0:
        {
            [self p_contentToTableViewCell:cell andArray:_firstSectionArr];
        }
            break;
        case 1:
        {
            [self p_contentToTableViewCell:cell andArray:_secondSectionArr];
        }
            break;
        default:
            break;
    }
    
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    return cell;
}

- (NSString *)tableView:(UITableView *)tableView titleForDeleteConfirmationButtonForRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString *sectionTitle = [NSString string];
    switch (indexPath.section) {
        case 0:
        {
            sectionTitle = @"提示选择";
        }
            break;
        case 1:
        {
            sectionTitle = @"功能选择";
        }
            break;
    }
    
    return sectionTitle;
}
#pragma UITableViewDelegate 
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [_f_tableView  cellForRowAtIndexPath:indexPath];
    if (cell.accessoryType == UITableViewCellAccessoryNone) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
//        if (indexPath.section == 0) {
//            _firstSectionArr
//        }
    } else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    switch (indexPath.section) {
        case 0:
        {
            
        }
            break;
        case 1:
        {
            
        }
            break;
    }

}

#pragma 给cell的内容赋值
- (void)p_contentToTableViewCell: (UITableViewCell *)cell andArray: (NSArray *)array {
    for (int count = 0; count < array.count; count ++) {
        GXFDisplayFunction *dFunction = (GXFDisplayFunction *)array[count];
        cell.imageView.image = [UIImage imageNamed:dFunction.imgName];
        cell.textLabel.text = dFunction.functionName;
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
