//
//  ICRHomeViewController.m
//  XFFruit
//
//  Created by Xummer on 3/24/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#define M_HEAD_IMG_VIEW_HEIGHT               (190)
#define M_HEAD_VIEW_TITLE_LABEL_HEIGHT       (30)
#define M_HEAD_IMG_HEIGHT_WIDTH_PROPORTION   190.0f/320.0f

#import "ICRHomeViewController.h"

#import "ICRTaskListViewController.h"
#import "ICRPatrolPlanViewController.h"
#import "ICRStoreListViewController.h"
#import "ICRStoreDetailViewController.h"
#import "ICRAnnouncementViewController.h"

#import "ICRFunctionBaseView.h"
#import "ICRFunctionEntity.h"
#import "ICRFunctionBaseView.h"

#import "NewSurveyViewController.h"
#import "SurveyViewController.h"
#import "AddWorkSheetViewController.h"
#import "NewPurchaseViewController.h"



#import "GXFFunctionsViewController.h"
#import "GXFDisplayFunction.h"
#import "GXFFunction.h"
#import "GXFNoticeFunctionTableViewCell.h"
#import "GXFFunctionCollectionViewCell.h"


#define ICRFUNCTION_IMG_TOP_PADDING   (25)
#define ICRFUNCTION_IMG_WIDTH         (65)
#define ICRFUNCTION_LABEL_HEIGHT      (15)
#define ICRFUNCTION_INNER_GAP         (5)
#define RIGHT_LINE_WIDTH              (0.5)
@interface ICRHomeViewController ()
<UITableViewDataSource,UITableViewDelegate,UICollectionViewDataSource,UICollectionViewDelegate>//,UICollectionViewDelegateFlowLayout>

@property (nonatomic, strong) UITableView *f_tableView;
@property (nonatomic, strong) NSArray *firstSectionArr;
@property (nonatomic, strong) NSArray *secondSectionArr;
@property (nonatomic, strong) UICollectionView *f_collectionView;

@end

@implementation ICRHomeViewController
static NSString *cellID = @"cell";
static NSString *collectionCellID = @"collectionCell";
//static CGFloat  colletionCellHeight [UIScreen mainScreen].bounds.size.width / 3.0
#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initData];
    [self setupSubviews];
    
    
}
- (void)setupSubviews {
    [self setupRightBarBtn];
    [self setupTableView];
    [self setupColletionView];
}
- (void)initData {
    NSDictionary *dictOne = @{@"Id":@(1),@"functionName":@"新建行情反馈",@"imgName":@"RefreshBtn",@"isSelected":@(0)};
    NSDictionary *dictTwo = @{@"Id":@(2),@"functionName":@"查询行情反馈",@"imgName":@"RefreshBtn",@"isSelected":@(1)};
    GXFDisplayFunction *dFuntionOne = [[GXFDisplayFunction alloc]initWithDictionary:dictOne];
    GXFDisplayFunction *dFuntionTwo = [[GXFDisplayFunction alloc]initWithDictionary:dictTwo];
    self.firstSectionArr = @[dFuntionOne,dFuntionTwo];
    self.secondSectionArr = @[dFuntionOne,dFuntionTwo];
    
    //self.firstSection =
}
- (void) setupRightBarBtn {
    UIBarButtonItem *rightBarBtn =  [[UIBarButtonItem alloc]initWithTitle:@"自定义功能" style:UIBarButtonItemStylePlain target:self action:@selector(defineFunctions)];

    self.navigationItem.rightBarButtonItem = rightBarBtn;
}

- (void)setupTableView {
    self.f_tableView = [[UITableView alloc]initWithFrame:self.view.frame style:UITableViewStyleGrouped];
    self.f_tableView.dataSource = self;
    self.f_tableView.delegate = self;
    //[self.f_tableView dequeueReusableCellWithIdentifier ]
    [self.view addSubview:_f_tableView];
}

- (void)setupColletionView {
    UICollectionViewFlowLayout *flowLayout = [[UICollectionViewFlowLayout alloc]init];
    [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
   // [flowLayout setItemSize:CGSizeMake(MODULE_VIEW_WIDTH, MODULE_VIEW_WIDTH)];
    
    self.f_collectionView = [[UICollectionView alloc]initWithFrame:CGRectMake(0, 0, self.view.width, 600) collectionViewLayout:flowLayout];
    //self.f_collectionView.collectionViewLayout = flowLayout;
    [self.f_collectionView registerClass:[UICollectionViewCell class] forCellWithReuseIdentifier:collectionCellID];
    _f_collectionView.backgroundColor = [UIColor whiteColor];
    self.f_collectionView.dataSource = self;
    self.f_collectionView.delegate = self;
}
#pragma BarButton Action
- (void)defineFunctions {
    GXFFunctionsViewController *functionsVc = [[GXFFunctionsViewController alloc]init];
    [self PushViewController:functionsVc animated:YES];
    
}

#pragma UITablewViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section == 0) {
        return _firstSectionArr.count;
    } else {
        return 1;
    }
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 1) {
        return 900;
    } else {
        return 44;
    }
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    
    if (!cell) {
        if (indexPath.section == 0) {
            cell = [[GXFNoticeFunctionTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        } else {
            cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"secondCell"];
            //self.f_collectionView.size =
            [cell.contentView addSubview:_f_collectionView];
      
            NSLog(@"%@",NSStringFromCGRect(cell.frame));
        }
    }
    
   // cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    return cell;
}

#pragma UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
}


#pragma 给cell的内容赋值
- (void)p_contentToTableViewCell: (UITableViewCell *)cell andArray: (NSArray *)array {
    for (int count = 0; count < array.count; count ++) {
        GXFDisplayFunction *dFunction = (GXFDisplayFunction *)array[count];
        cell.imageView.image = [UIImage imageNamed:dFunction.imgName];
        cell.textLabel.text = dFunction.functionName;
    }
}


#pragma UICollectionViewDataSource,UICollectionViewDelegate

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView {
    return 1;
}
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 6;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
   UICollectionViewCell *collectionCell = [collectionView dequeueReusableCellWithReuseIdentifier:collectionCellID forIndexPath:indexPath];
    
    UIImageView *functionImg =[[UIImageView alloc]initWithFrame:(CGRect){
        .origin.x = (CGRectGetWidth(collectionCell.frame) - ICRFUNCTION_IMG_WIDTH)/2,
        .origin.y = ICRFUNCTION_IMG_TOP_PADDING,
        .size.width = ICRFUNCTION_IMG_WIDTH,
        .size.height = ICRFUNCTION_IMG_WIDTH
    }];
    functionImg.image = [UIImage imageNamed:@"create_purchase"];
    [collectionCell.contentView addSubview:functionImg];
    
    UILabel *lbl = [[UILabel alloc]initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = CGRectGetMaxY(functionImg.frame) + ICRFUNCTION_INNER_GAP,
        .size.width = collectionCell.width,
        .size.height = ICRFUNCTION_LABEL_HEIGHT
  
    }];
    lbl.textAlignment = NSTextAlignmentCenter;
    lbl.tintColor = [UIColor blackColor];
    lbl.text = @"kkk";
    [collectionCell.contentView addSubview:lbl];


    //collectionCell.backgroundColor = [UIColor yellowColor];
    return collectionCell;
}

//UICollectionViewDelegateFlowLayout是UICollectionViewDelegate的子协议
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath{
    CGFloat width = self.view.width / 3.0;
     return CGSizeMake((self.view.width - 30) / 3.0,width);
}
- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout insetForSectionAtIndex:(NSInteger)section{
    //top, CGFloat left, CGFloat bottom, CGFloat right
    return UIEdgeInsetsMake(0, 5, 0, 5);
}

@end
