//
//  ProductViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ProductViewController.h"
#import "FooterCell.h"
#import "HeaderCell.h"
#import "ProductCell.h"
#define TableHeight 44

@interface ProductViewController ()<UITableViewDataSource,UITableViewDelegate,FooterCellDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
@end

@implementation ProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [super viewDidLoad];
    [self initData];
    [self createView];
}
- (void)initData{
    _selectRowArr = [[NSMutableArray alloc]init];
    if (!self.productArr) {
        self.productArr = [NSMutableArray array];
    }
    [self.productArr addObject:@"ffff"];
    [self.productArr addObject:@"fffff"];
}

- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr];
    [self.view addSubview:headCell];
    self.tableView.tableHeaderView = headCell;
    
    if (!self.isHiddenEdit) {
        FooterCell *footCell = [[FooterCell alloc]initWithFrame:CGRectMake(0, 0, _tableFrame.size.width, 50) withTitle:@"+点击添加商品明细"];
        [self.view addSubview:footCell];
        footCell.delegate = self;
        self.tableView.tableFooterView = footCell;
    }
}

- (void)addClick{
    [self.productArr addObject:@"dddd"];
    [self.tableView reloadData];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.productArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"ProductCell";
    ProductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[ProductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = 200-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 150;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = [UIColor whiteColor];
    }
    return cell;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ProductCell *cell = (ProductCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];

        Linefrmame.origin.y = 200-1;
        showfrmame.size.height = 150;
//        cell.showView.hidden = NO;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
//        cell.showView.hidden = YES;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return 200;
    }
    return TableHeight;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
