//
//  TopPurchaseView.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TopPurchaseView.h"

#import "SurveyCell.h"
#import "ChooseVendorViewController.h"
#import "Vendor.h"
#define LeftMargin 15
#define TopMargin 20
#define LeftWidth 80
#define TableHeight 44
#define SpaceHeight 10
#define TitleSize 15

@interface TopPurchaseView ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
}
@end


@implementation TopPurchaseView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.backgroundColor  = XXFBgColor;
    _dataArr = [NSMutableArray array];
    NSArray *arr = @[@"采购通知:",@"类型:",@"供应商:",@"收货仓库:",@"总金额:",@"备注:"];
    [_dataArr addObjectsFromArray:arr];
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,self.frame.size.width, self.frame.size.height - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self addSubview:_tableView];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row !=4 && indexPath.row != 5) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}
-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 4 ) {
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = HexColor(@"444444");
        textField.font = FontSize(15);
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        self.purchasePriceFiled = textField;
        self.purchasePriceFiled.placeholder = @"请输总金额";
        
    }else if (indexPath.row == _dataArr.count -1){
        self.remarkTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        self.remarkTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        self.remarkTextView.minNumberOfLines = 1;
        self.remarkTextView.maxNumberOfLines = 2;
        self.remarkTextView.font = FontSize(15);
        self.remarkTextView.textAlignment = NSTextAlignmentRight;
        self.remarkTextView.delegate = self;
        self.remarkTextView.returnKeyType = UIReturnKeyDone;
        self.remarkTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:self.remarkTextView];
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = HexColor(@"bbbbbb");
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 0) {
            contentLabel.text = @"选择采购通知";
            self.purchaseNoticeLabel = contentLabel;
            
        }else if(indexPath.row == 1){
            contentLabel.text = @"选择类型";
            self.purchaseTypeLabel = contentLabel;
            
        }else if(indexPath.row == 2){
            contentLabel.text = @"选择供应商";
            self.purchaseSupplierLabel = contentLabel;
            
        }else if(indexPath.row == 3){
            contentLabel.text = @"选择收货仓库";
            self.purchaseStoreLabel = contentLabel;
            
        }
    }
}
-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 2){
        ChooseVendorViewController *cvc = [ChooseVendorViewController new];
        cvc.choseVendor = ^(NSArray *vendors){
            if (vendors.count > 0) {
                Vendor *vendor = vendors[0];
              self.purchaseSupplierLabel.text = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
                 self.purchaseSupplierLabel.textColor = HexColor(@"444444");
            }
            
        };
        cvc.isMoreChose = NO;
        [self.delegate pushNextViewController:cvc];
    }
}
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [self.remarkTextView resignFirstResponder];
    return YES;
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.delegate hiddenKeyBoard];
    return YES;
}

@end
