//
//  AddWorkSheetViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/12.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "AddWorkSheetViewController.h"
#import "TopSheetView.h"
#import "BottomSheetView.h"
#define TopHeight 284
#define BottomHeight 300
#define SpaceHeight 20
#define BottomViewHeight 60



typedef enum : NSUInteger {
    SaveTag = 7000,
    CommitTag,
} BtnTag;

@interface AddWorkSheetViewController ()<TopSheetViewDelegate,UIScrollViewDelegate>
{
    UIScrollView *_scrollView;
    TopSheetView *_sheetView;
    BottomSheetView *_bottomView;
}
@end

@implementation AddWorkSheetViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"加工单";
    //布局
    [self bulidLayout];
}
- (void)bulidLayout{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64 - BottomViewHeight )];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"50bd62")];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"f69100")];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];
    
    _sheetView = [[TopSheetView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _sheetView.delegate = self;
    [_scrollView addSubview:_sheetView];
    
    _bottomView = [[BottomSheetView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_sheetView.frame) + 20, ScreenSize.width,BottomHeight)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
}

- (void)btnClick:(UIButton *)btn{
    

}



#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_sheetView.titleTextFiled resignFirstResponder];
    [_sheetView.peopleTextFiled resignFirstResponder];
    [_sheetView.peopleTextFiled resignFirstResponder];
    [_sheetView.phoneTextFiled resignFirstResponder];
    [_sheetView.remarkTextView resignFirstResponder];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
