//
//  IBTAdditionsObserver.m
//  Cruiser
//
//  Created by Xummer on 3/26/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTAdditionsObserver.h"
#import "UIApplication+CheckFirstRun.h"

static IBTAdditionsObserver *sSharedInstance;

@implementation IBTAdditionsObserver

+ (void)load {
    [self performSelectorOnMainThread:@selector(sharedInstance)
                           withObject:nil waitUntilDone:NO];
}

+ (IBTAdditionsObserver *)sharedInstance {
    static dispatch_once_t  onceToken;
    dispatch_once(&onceToken, ^{
        sSharedInstance = [[IBTAdditionsObserver alloc] init];
    });
    return sSharedInstance;
}

- (id)init {
    self = [super init];
    if (self) {
        NSNotificationCenter *notiCenter = [NSNotificationCenter defaultCenter];
        [notiCenter addObserver:self
                       selector:@selector(AppWillTerminate)
                           name:UIApplicationWillResignActiveNotification
                         object:nil];
    }
    return self;
}

- (void)AppWillTerminate {
    [[UIApplication sharedApplication] setNotFirstRun];
}

- (void)dealloc {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
