//
//  IBTCommon.m
//  AceMTer
//
//  Created by Xummer on 2/27/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTCommon.h"

@implementation IBTCommon

+ (NSString *)localizableString:(NSString *)text
{
    /*
     NSString *settingLanguge = [[TWDocument unarchive] language];
     
     NSString *directoryName = [NSString stringWithString:settingLanguge];
     directoryName = [directoryName stringByAppendingString:@".lproj"];
     NSString *tableName = [directoryName stringByAppendingPathComponent:@"Localizable"];
     text = NSLocalizedStringFromTable(text, tableName, text);
     */
    
    return NSLocalizedString(text, nil);
}

+ (UIImage *)localizableImage:(NSString *)name
{
    UIImage *image = nil;
    /*
     NSString *settingLanguge = [[TWDocument unarchive] language];
     
     NSString *directoryName = [NSString stringWithString:settingLanguge];
     directoryName = [directoryName stringByAppendingString:@".lproj"];
     NSString *filePath = [[NSBundle mainBundle] pathForResource:name ofType:nil inDirectory:directoryName];
     image = [UIImage imageWithContentsOfFile:filePath];
     */
    return image;
}

+ (UIImage *)appIcon {
    /*
     CFBundleIcons =     {
     CFBundlePrimaryIcon =         {
     CFBundleIconFiles =             (
     AppIcon29x29,
     AppIcon40x40,
     AppIcon57x57,
     AppIcon60x60,
     AppIcon120x120
     );
     };
     };
     */
    
    NSArray *arrIcons = [[NSBundle mainBundle] infoDictionary][ @"CFBundleIcons" ][ @"CFBundlePrimaryIcon" ][ @"CFBundleIconFiles" ];
    UIImage *appIcon = nil;
    NSUInteger uiIconCount = [arrIcons count];
    for (NSInteger i = uiIconCount - 1; i >= 0; i -- ) {
        appIcon = [UIImage imageNamed:arrIcons[ i ]];
        if (appIcon) {
            break;
        }
    }
    
    return appIcon;
}

#pragma mark - Thread
+ (void)runOnMainThreadWithoutDeadlocking:(void (^)(void))block {
    if ([NSThread isMainThread]) {
        block();
    }
    else{
        dispatch_async(dispatch_get_main_queue(), block);
    }
}

@end
