//
//  ICRUserUtil.h
//  Cruiser
//
//  Created by Xummer on 3/29/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface ICRUserUtil : IBTObject <NSCoding, NSCopying>

// Login Data
@property (copy, nonatomic) NSString *userName;
@property (copy, nonatomic) NSString *password;
@property (copy, nonatomic) NSString *registerCode;
@property (copy, nonatomic) NSString *token;
@property (copy, nonatomic) NSNumber *bAutoLogin;

// User Data
@property (copy, nonatomic) NSString *displayName;
@property (copy, nonatomic) NSString *orgCode;
@property (copy, nonatomic) NSString *orgName;

+ (instancetype)sharedInstance;

- (BOOL)saveArchive;

- (BOOL)isLogin;

- (void)storageUserName:(NSString *)userName
               password:(NSString *)password
           registerCode:(NSString *)registerCode
                  token:(NSString *)token;

@end
