//
//  JTRecordView.m
//  JobTalk
//
//  Created by Xummer on 14-7-29.
//  Copyright (c) 2014年 BST. All rights reserved.
//

#define INDICATOR_WIDTH     (120)
#define RECORD_PADDING      (10)
#define RECORD_LABEL_HEIGHT (20)

#import "JTRecordView.h"

@interface JTRecordView ()
@property (strong, nonatomic) UIImageView* m_recordIndicateView;
@property (strong, nonatomic) UILabel* m_recordLabel;
@end

@implementation JTRecordView

#pragma mark - Life Cycle
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self m_init];
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    self.m_recordIndicateView.frame = (CGRect){
        .origin.x = (CGRectGetWidth(self.bounds) - INDICATOR_WIDTH) * .5f,
        .origin.y = (CGRectGetHeight(self.bounds) - INDICATOR_WIDTH) * (1 - 0.618),
        .size.width = INDICATOR_WIDTH,
        .size.height = INDICATOR_WIDTH
    };
    
    self.m_recordLabel.frame = (CGRect){
        .origin.x = RECORD_PADDING,
        .origin.y = CGRectGetHeight(_m_recordIndicateView.bounds) - RECORD_PADDING - RECORD_LABEL_HEIGHT,
        .size.width = CGRectGetWidth(_m_recordIndicateView.bounds) - 2 * RECORD_PADDING,
        .size.height = RECORD_LABEL_HEIGHT
    };
}

#pragma mark - Public Method
- (void)updateWithWavePower:(NSUInteger)power {
    
    if (power < 1) {
        power = 1;
    }
    else if (power > 4) {
        power = 4;
    }
    
    NSString *waveName = [NSString stringWithFormat:@"recorder_animation_0%ld",(long)power];
    
    self.m_recordIndicateView.image = [UIImage imageNamed:waveName];
}

#pragma mark - Private Method

- (void)m_init {
    self.backgroundColor = [UIColor clearColor];
    self.m_recordIndicateView = [[UIImageView alloc] init];
    _m_recordIndicateView.backgroundColor = [UIColor colorWithW:0 a:.8];
    _m_recordIndicateView.contentMode = UIViewContentModeCenter;
    _m_recordIndicateView.layer.cornerRadius = 5;
    _m_recordIndicateView.layer.masksToBounds = YES;
    
    self.m_recordLabel = [[UILabel alloc] init];
    _m_recordLabel.font = [UIFont boldSystemFontOfSize:13];
    _m_recordLabel.adjustsFontSizeToFitWidth = YES;
    _m_recordLabel.textColor = [UIColor whiteColor];
    _m_recordLabel.textAlignment = NSTextAlignmentCenter;
    
    _m_recordLabel.text = @"松手结束";
    
    [_m_recordIndicateView addSubview:_m_recordLabel];
    
    [self addSubview:_m_recordIndicateView];
    
    
    
    [self updateWithWavePower:1];
}

@end
