//
//  RejectView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/26.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "RejectView.h"
#define GXFPOpView_LeftMargin 20
#define GXFPOpView_ContentHeight 230
#define GXFPOpView_TopHeight 44
@implementation RejectView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{
    self.backgroundColor = RGBA(0, 0, 0, 0.5);
    UIScrollView *bgView = [[UIScrollView alloc]initWithFrame:CGRectMake(GXFPOpView_LeftMargin, (ScreenSize.height - GXFPOpView_ContentHeight)/2, ScreenSize.width - GXFPOpView_LeftMargin*2, GXFPOpView_ContentHeight)];
    bgView.backgroundColor = XXFBgColor;
    bgView.layer.cornerRadius = 4;
    bgView.layer.masksToBounds = YES;
    [self addSubview:bgView];
    
    
    UILabel *titlelabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 0, CGRectGetWidth(bgView.frame)- 20, GXFPOpView_TopHeight-1)];
    titlelabel.text = @"请输入拒绝原因";
    titlelabel.textColor = GXF_PopView_COLOR;
    [bgView addSubview:titlelabel];
    
    UILabel *lineLabel = [[UILabel alloc]initWithFrame:CGRectMake(0, GXFPOpView_TopHeight-1, CGRectGetWidth(bgView.frame), 1)];
    lineLabel.backgroundColor = GXF_PopView_COLOR;
    [bgView addSubview:lineLabel];
    
    
    
    
    UIScrollView *scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, GXFPOpView_TopHeight, CGRectGetWidth(bgView.frame), GXFPOpView_ContentHeight - GXFPOpView_TopHeight*2)];
//    scrollView.bounces = NO;
    scrollView.backgroundColor = [UIColor redColor];
    scrollView.showsHorizontalScrollIndicator = NO;
    scrollView.showsVerticalScrollIndicator = NO;
    scrollView.contentSize = CGSizeMake(CGRectGetWidth(bgView.frame), GXFPOpView_ContentHeight - GXFPOpView_TopHeight*2);
    [bgView addSubview:scrollView];
    
    self.rejectTextView = [[ICRPlaceholderTextView alloc] initWithFrame:CGRectMake(0,0, CGRectGetWidth(bgView.frame), GXFPOpView_ContentHeight - GXFPOpView_TopHeight*2 -10)];

    self.rejectTextView.font = [UIFont systemFontOfSize:16.0f];
    self.rejectTextView.m_placeHolder = @"请输入拒绝原因";
    self.rejectTextView.m_placeholderColor = [UIColor colorWithW:109 a:1];
    [scrollView addSubview:self.rejectTextView];
    
    
    
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(0, CGRectGetHeight(bgView.frame)- GXFPOpView_TopHeight, CGRectGetWidth(bgView.frame)/2, GXFPOpView_TopHeight);
    [btn setTitle:@"取消" forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(cancelClick) forControlEvents:UIControlEventTouchUpInside];
    [btn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    
    [bgView addSubview:btn];
    
    UIButton *sureBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    sureBtn.frame = CGRectMake(btn.right, CGRectGetHeight(bgView.frame)- GXFPOpView_TopHeight, CGRectGetWidth(bgView.frame)/2, GXFPOpView_TopHeight);
    [sureBtn setTitle:@"确定" forState:UIControlStateNormal];
    [sureBtn addTarget:self action:@selector(sureClick) forControlEvents:UIControlEventTouchUpInside];
    [sureBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    
    [bgView addSubview:sureBtn];
}
- (void)cancelClick{

}

- (void)sureClick{
    
}


@end
