//
//  TransportCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportCell.h"
#define TitleSize 16
#define LeftMargin 90
#define TopMargin 10
#define TitleHeight 20
#define TableHeight 120

@implementation TransportCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.stateBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.stateBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftMargin - TopMargin*3, 20);
    self.stateBtn.titleLabel.font = GXF_FOURTEENTH_SIZE;
    [self.stateBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stateBtn.enabled = NO;
    
    self.billNumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, TopMargin, ScreenSize.width - LeftMargin, TitleHeight))];
    self.billNumberLabel.textColor = GXF_CONTENT_COLOR;
    self.billNumberLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.warehouseLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.billNumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.warehouseLabel.numberOfLines = 0;
    self.warehouseLabel.textColor = GXF_CELL_COLOR;
    self.warehouseLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.carnumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.warehouseLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.carnumberLabel.textColor = GXF_CELL_COLOR;
    self.carnumberLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.createOperNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.carnumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createOperNameLabel.textColor = GXF_CELL_COLOR;
    self.createOperNameLabel.font = GXF_FOURTEENTH_SIZE;
    
    
    self.createTimeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.createOperNameLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createTimeLabel.textColor = GXF_CELL_COLOR;
    self.createTimeLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width - LeftMargin - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.stateBtn];
    [self.contentView addSubview:self.billNumberLabel];
    [self.contentView addSubview:self.warehouseLabel];
    [self.contentView addSubview:self.carnumberLabel];
    [self.contentView addSubview:self.createOperNameLabel];
    [self.contentView addSubview:self.createTimeLabel];
    [self.contentView addSubview:self.lineLabel];
    
}
- (void)setTransport:(Transport *)transport{
    self.billNumberLabel.text = [NSString stringWithFormat:@"单号：%@",transport.billnumber];
    self.warehouseLabel.text = [NSString stringWithFormat:@"仓库：%@-%@",transport.warehouseName,transport.rwarehouseName];
    self.carnumberLabel.text = [NSString stringWithFormat:@"车辆：%@",transport.carnumber] ;
    self.createOperNameLabel.text = [NSString stringWithFormat:@"创建人：%@",transport.create_operName] ;
    self.createTimeLabel.text =[NSString stringWithFormat:@"创建时间：%@",transport.create_time];
    NSString *stateStr = @"";
    if ([transport.state isEqualToString:TRANSPORT_STATE_INITIAL]) {
        stateStr = @"未提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"initial"]  forState:UIControlStateDisabled];
    }else if ([transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED]) {
        stateStr = @"待收货";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
    }else if ([transport.state isEqualToString:TRANSPORT_STATE_RECEIVED]) {
        stateStr = @"已收货";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
        
    }else if ([transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        stateStr = @"已作废";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
        
    }else if ([transport.state isEqualToString:TRANSPORT_STATE_FINISHED]) {
        stateStr = @"已完成";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
    }
    [self.stateBtn setTitle:stateStr forState:UIControlStateNormal];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
